#include <Arduino.h>
//
#include "PCA9685.h"

const int PWM_MINIMUM = 200;
const int PWM_MAXIMUM = 450;
const int PWM_MEDIUM  = 320;


PCA9685 pwmController;   // Library using default B000000 (A5-A0) i2c address, and default Wire @400kHz



void setup() 
{
  Serial.begin(115200);

  Wire.begin();
  pwmController.resetDevices();       
  pwmController.init();               
  pwmController.setPWMFrequency(50); 
  pwmController.setChannelPWM(0, PWM_MEDIUM);
  pwmController.setChannelPWM(1, PWM_MEDIUM);
}

void loop() 
{
  pwmController.setChannelPWM(0, PWM_MINIMUM);
  pwmController.setChannelPWM(1, PWM_MINIMUM);
  delay(2000);
  for (int I = PWM_MINIMUM; I <= PWM_MAXIMUM; I += 1)
  {
    pwmController.setChannelPWM(0, I);
    pwmController.setChannelPWM(1, I);
    //Serial.println(pwmController.getChannelPWM(0)); // Should output 2048, which is 128 << 4
    delay(10);
  }
  pwmController.setChannelPWM(0, PWM_MAXIMUM);
  pwmController.setChannelPWM(1, PWM_MAXIMUM);
  delay(2000);
  for (int I = PWM_MAXIMUM; PWM_MINIMUM <= I; I -= 1)
  {
    pwmController.setChannelPWM(0, I);
    pwmController.setChannelPWM(1, I);
    //Serial.println(pwmController.getChannelPWM(0)); // Should output 2048, which is 128 << 4
    delay(10);
  }
}
