//
#include "Define.h"
#include "PulseWidthModulator.h"
//
const int PIN_MOTORA_PWM = PB10;
const int PIN_MOTORB_PWM = PB11;
const int PIN_SERVOA_PWM = PB1;
const int PIN_SERVOB_PWM = PB0;
//
const int FREQUENCY_MOTOR = 20000; // [kHz]
const int FREQUENCY_SERVO = 50;    // [kHz]
//
const int MIN_MOTORA = 10; // [%]
const int MAX_MOTORA = 90; // [%]
const int MIN_MOTORB = 10; // [%]
const int MAX_MOTORB = 90; // [%]
//
const int MIN_SERVOA = 10; // [%]
const int MAX_SERVOA = 90; // [%]
const int MIN_SERVOB = 10; // [%]
const int MAX_SERVOB = 90; // [%]
//
// Pwm Motor
CPulseWidthModulator MotorA(PIN_MOTORA_PWM);
CPulseWidthModulator MotorB(PIN_MOTORB_PWM);
// Pwm Servo
CPulseWidthModulator ServoA(PIN_SERVOA_PWM);
CPulseWidthModulator ServoB(PIN_SERVOB_PWM);
//
void setup()
{ 
}
//
void loop()
{
  for (int I = 0; I < 100; I += 1)
  { // Motor
    int PwmMotorA = min(MAX_MOTORA, max(MIN_MOTORA, I));
    int PwmMotorB = min(MAX_MOTORB, max(MIN_MOTORB, 100 - I));
    MotorA.SetFrequencyPwm(FREQUENCY_MOTOR, PwmMotorA);
    MotorB.SetFrequencyPwm(FREQUENCY_MOTOR, PwmMotorB);
    // Servo
    int PwmServoA = min(MAX_SERVOA, max(MIN_SERVOA, I));
    int PwmServoB = min(MAX_SERVOA, max(MIN_SERVOB, 100 - I));
    ServoA.SetFrequencyPwm(FREQUENCY_SERVO, PwmServoA);
    ServoB.SetFrequencyPwm(FREQUENCY_SERVO, PwmServoB);
    //
    delay(100);
  }
}
