//
#ifndef Define_h
#define Define_h
//
#include <Arduino.h>
//
//-------------------------------------------------------
//  Types - STM32F103C8T6
//-------------------------------------------------------   
#define CONTROLLER_STM32F103C8T6
#ifdef CONTROLLER_STM32F103C8T6
//
#undef  DEBUG
//#define DEBUG
//
typedef char Character;
typedef const char CCharacter;
typedef char* PCharacter;
typedef const char* PCCharacter;
typedef bool Boolean;
//typedef String 
typedef int8_t Int8;
typedef uint8_t UInt8;
typedef int16_t Int16;
typedef uint16_t UInt16;
typedef int32_t Int32;
typedef uint32_t UInt32;
typedef int64_t Int64;
typedef uint64_t UInt64;
typedef float Float32;
typedef double Double64;
//
typedef float TPercent;
typedef int TPin;
//
#define SERIAL_PC Serial2
//#define SERIAL_XY Serial1
//#define SERIAL_UV Serial2
//const int ID_UART0 = 0;
//const int ID_UART1 = 1;
//
const int PIN_LEDSYSTEM = PC13;
//
const int PIN_UART0_TX = 1;
const int PIN_UART0_RX = 2;
//
#endif // CONTROLLER_STM32F103C8T6
//
//-------------------------------------------------------
//  Helper
//-------------------------------------------------------   
void ZeroBuffer(void);
PCCharacter BuildTxLine(CCharacter header, CCharacter source, CCharacter target,
                        PCCharacter pcommand, PCCharacter pparameter);
//
//-------------------------------------------------------
//  Format
//-------------------------------------------------------   
const char* Format(const char* mask, char* argument);
const char* Format(const char* mask, const char* argument);
const char* Format(const char* mask, Int32 argument);
const char* Format(const char* mask, UInt32 argument);
const char* Format(const char* mask, Float32 argument);
const char* Format(const char* mask, Double64 argument);
//
//-------------------------------------------------------
//  Output
//-------------------------------------------------------   
void Message(const char* message);
void Warning(const char* warning);
void Error(const char* error);
void Debug(const char* debug);
void Debug(const char* mask, char* debug);
void Debug(const char* mask, const char* debug);
//
//-------------------------------------------------------
//  Ressources
//-------------------------------------------------------   
#define SYMBOL_ALL          (CCharacter)'A'
#define SYMBOL_COMMANDER    (CCharacter)'P'
#define SYMBOL_CONTROLLER   (CCharacter)'C'
#define SYMBOL_HARDWARE     (CCharacter)'H'
#define SYMBOL_SCRIPTOR     (CCharacter)'S'
#define SYMBOL_ESP32        (CCharacter)'E'
#define SYMBOL_REMOTER      (CCharacter)'R'
//
#define TOKEN_COMMAND       (CCharacter)'@'
#define TOKEN_RESPONSE      (CCharacter)'$'
#define TOKEN_EVENT         (CCharacter)'!'
#define TOKEN_COMMENT       (CCharacter)'#'
#define TOKEN_WARNING       (CCharacter)'.'
#define TOKEN_ERROR         (CCharacter)':'
//
//-------------------------------------------------------
//  Commands
//-------------------------------------------------------
#define COMMAND_LEDSYSTEM_SETON         (PCCharacter)"LSO"
#define COMMAND_LEDSYSTEM_SETOFF        (PCCharacter)"LSF"
//
#define COMMAND_MOTORLEFT_MOVEPOSITIVE  (PCCharacter)"MLP"
#define COMMAND_MOTORLEFT_MOVENEGATIVE  (PCCharacter)"MLN"
#define COMMAND_MOTORLEFT_STOP          (PCCharacter)"MLS"
#define COMMAND_MOTORRIGHT_MOVEPOSITIVE (PCCharacter)"MRP"
#define COMMAND_MOTORRIGHT_MOVENEGATIVE (PCCharacter)"MRN"
#define COMMAND_MOTORRIGHT_STOP         (PCCharacter)"MRS"
//
#endif // Define_h
//