//
#include "Define.h"
//
#include "PulseWidthModulator.h"
//
CPulseWidthModulator::CPulseWidthModulator(int pin)
{
  FPin = pin;
  FPInstance = (TIM_TypeDef *)pinmap_peripheral(digitalPinToPinName(FPin), PinMap_PWM);  
  FPTimer = new HardwareTimer(FPInstance);
  FChannel = STM_PIN_CHANNEL(pinmap_function(digitalPinToPinName(FPin), PinMap_PWM));
}
//
void CPulseWidthModulator::SetFrequencyPwm(int frequency, int pwm)
{
  FPTimer->pause();
  FPTimer->setPWM(FChannel, FPin, frequency, pwm);
  FPTimer->refresh();
  FPTimer->resume();
}
//
