//
#include "Define.h"
//
#ifndef Led_h
#define Led_h
//
enum EStateLed
{
    slUndefined = -1,
    slOff = 0,
    slOn = 1
};
//------------------------------------------------------------------
// Callback - LedSystem
//------------------------------------------------------------------
typedef void (*TCB_Led_OnStateChanged)(EStateLed state);
//
//------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------
class CLed
{
    private:
    EStateLed FState;
    Boolean FInverted;
    TPin FPin;
    TCB_Led_OnStateChanged FOnStateChanged;
    //
    public:
    CLed(TPin pin, Boolean inverted, TCB_Led_OnStateChanged onstatechanged);
    //
    void SetState(EStateLed state);
    void SetOn(void);
    void SetOff(void);
    //
    Boolean Open(void);
    Boolean Close(void);
};
//
#endif // Led_h
//
