#include "Define.h"
//
#include "Define.h"
#include "CUart.h"
#include "Dispatcher.h"
#include "Servo.h"
#include "Motor.h"
//
extern CUart UartCRB;         
extern CDispatcher Dispatcher;
extern CLed LedSystem;
extern CMotor MotorL;
extern CMotor MotorR;
extern CServo ServoL;
extern CServo ServoR;
//
//------------------------------------------------------------
//
//------------------------------------------------------------
void UartCRB_OnRxLine(String rxline)
{  // Message(Format("UartCRB_OnRxLine[%s]", rxline.c_str()));
  Message(rxline.c_str());
  Dispatcher.PushRxLine(rxline);
}
String UartCRB_OnTxLine(String txline)
{  // Message(Format("UartCRB_OnTxLine[%s]", txline.c_str()));
  Message(txline.c_str());
  return txline;
}
//------------------------------------------------------------
//  LedSystem - Event
//------------------------------------------------------------
void LedSystem_OnStateChanged(EStateLed state)
{  
  Dispatcher.PushTxLine(Format("!TA SLS %d", (Int32)state));
}
//------------------------------------------------------------
//  LedSystem - Command
//------------------------------------------------------------
void LedSystem_OnSetOn(void)
{ // Message("LedSystem_OnSetOn");
  LedSystem.SetOn();
}
void LedSystem_OnSetOff(void)
{  // Message("LedSystem_OnSetOff");
  LedSystem.SetOff();
}
//------------------------------------------------------------
//  Motor - Left - Event
//------------------------------------------------------------
void MotorL_OnStateChanged(EStateMotor state)
{  
}
void MotorL_OnVelocityChanged(TPercent pwm)
{
}
//------------------------------------------------------------
//  Motor - Left - Command
//------------------------------------------------------------
void MotorL_OnMovePositive(TPercent pwm)
{
  MotorL.MovePositive(pwm);
}
void MotorL_OnMoveNegative(TPercent pwm)
{
  MotorL.MoveNegative(pwm);
}
void MotorL_OnFreeRun()
{
  MotorL.FreeRun();
}
void MotorL_OnForceHalt()
{
  MotorL.ForceHalt();
}
//------------------------------------------------------------
//  Motor - Right - Event
//------------------------------------------------------------
void MotorR_OnStateChanged(EStateMotor state)
{  
}
void MotorR_OnVelocityChanged(TPercent velocity)
{
}
//------------------------------------------------------------
//  Motor - Right - Command
//------------------------------------------------------------
void MotorR_OnMovePositive(TPercent pwm)
{
  MotorR.MovePositive(pwm);
}
void MotorR_OnMoveNegative(TPercent pwm)
{
  MotorR.MoveNegative(pwm);
}
void MotorR_OnFreeRun()
{
  MotorR.FreeRun();
}
void MotorR_OnForceHalt()
{
  MotorR.ForceHalt();
}




//------------------------------------------------------------
//  Servo - Left - Event
//------------------------------------------------------------
void ServoL_OnStateChanged(EStateServo state)
{  
}
//------------------------------------------------------------
//  Servo - Left - Command
//------------------------------------------------------------
void ServoL_OnSetPosition(TPercent pwm)
{
  ServoL.SetPosition(pwm);
}
void ServoL_OnSetLow(void)
{
  ServoL.SetLow();
}
void ServoL_OnSetMiddle(void)
{
  ServoL.SetMiddle();
}
void ServoL_OnSetHigh(void)
{
  ServoL.SetHigh();
}
//------------------------------------------------------------
//  Servo - Right - Event
//------------------------------------------------------------
void ServoR_OnStateChanged(EStateServo state)
{  
}
//------------------------------------------------------------
//  Servo - Right - Command
//------------------------------------------------------------
void ServoR_OnSetPosition(TPercent pwm)
{
    ServoR.SetPosition(pwm);
}
void ServoR_OnSetLow(void)
{
    ServoR.SetLow();
}
void ServoR_OnSetMiddle(void)
{
  ServoR.SetMiddle();
}
void ServoR_OnSetHigh(void)
{
  ServoR.SetHigh();
}
//
//--------------------------------------------------------------
//
//--------------------------------------------------------------

CUart UartCRB(NULL, PIN_UARTPC_RX, PIN_UARTPC_TX, 
             BAUDRATE_UARTPC, UartCRB_OnRxLine, UartCRB_OnTxLine); 
CDispatcher Dispatcher(UartCRB_OnTxLine,
                       LedSystem_OnSetOn, LedSystem_OnSetOff,
                       MotorL_OnMovePositive, MotorL_OnMoveNegative,
                       MotorL_OnFreeRun, MotorL_OnForceHalt,
                       MotorR_OnMovePositive, MotorR_OnMoveNegative,
                       MotorR_OnFreeRun, MotorR_OnForceHalt,
                       ServoL_OnSetPosition, ServoL_OnSetLow,
                       ServoL_OnSetMiddle, ServoL_OnSetHigh,
                       ServoR_OnSetPosition, ServoR_OnSetLow,
                       ServoR_OnSetMiddle, ServoR_OnSetHigh);
CLed LedSystem(PIN_LEDSYSTEM, true, LedSystem_OnStateChanged);
CServo ServoL(PIN_PWM_PB11, ServoL_OnStateChanged, ServoL_OnSetPosition);
CServo ServoR(PIN_PWM_PB10, ServoR_OnStateChanged, ServoR_OnSetPosition);
CMotor MotorL(PIN_PWM_PB1, PIN_PWM_PB0,
              MotorL_OnStateChanged, MotorL_OnVelocityChanged);
CMotor MotorR(PIN_PWM_PA7, PIN_PWM_PA6,
              MotorR_OnStateChanged, MotorR_OnVelocityChanged);
//
void setup()
{ 
    UartCRB.Open();
    Dispatcher.Open();
    delay(2200);
    Message("\r\n*** Stm32F103CrbServoMotor");
    Message("Version...: 00V05");
    Message("Date......: 220414");
    Message("Time......: 0843");
    Message("Author....: OMdevelop");
    //
    LedSystem.Open();
}
//
void loop()
{
  UartCRB.Execute();
  Dispatcher.Execute();
}
//#####################################################################
  // PServoA->Open(50);
  // PServoB->Open(50);
  //delay(2000);
  //PMotorL->Open();
  // PMotorL->MoveForward(0);
  //PMotorR->Open();
  // PMotorR->MoveForward(0);

  //Message("...");
  //delay(10000);
  // for (int I = 4; I <= 14; I += 1)
  // { 
  //   PServoA->SetPosition(I);
  //   PServoB->SetPosition(18 - I);
  //   delay(3500);
  // }    
  // for (int I = 14; 4 <= I; I -= 1)
  // { 
  //   PServoA->SetPwmSignal(I);
  //   PServoB->SetPwmSignal(18 - I);
  //   delay(3500);
  // }    
  //delay(20000);
  // for (int I = 60; I <= 70; I += 1)
  // {
  //   PMotorL->MoveForward(I);
  //   PMotorR->MoveBackward(I);
  //   delay(350);
  // }
  // delay(2000);
  // for (int I = 70; 60 <= I; I -= 1)
  // {
  //   PMotorL->MoveForward(I);
  //   PMotorR->MoveBackward(I);
  //   delay(350);
  // }
  //delay(2000);
  // PMotorL->FreeRun();
  // PMotorR->FreeRun();
