//
#include "Define.h"
//
#include "CUart.h"
//
extern CUart UartCRB;
//
const int SIZE_BUFFER = 32;
PCharacter Buffer = new char[SIZE_BUFFER];
void ZeroBuffer(void)
{
  for(int CI = 0; CI < SIZE_BUFFER; CI++)
  {
    Buffer[CI] = 0x00;
  }
}
//
PCCharacter BuildTxLine(CCharacter header, CCharacter source, CCharacter target,
                        PCCharacter pcommand, PCCharacter pparameter)
{
  sprintf(Buffer, "%c%c%c %s %s", header, source, target, pcommand, pparameter);
  return Buffer;
}

PCCharacter ResponseTxdLine(CCharacter source, CCharacter target, 
                            PCCharacter pcommand, PCCharacter presult, PCCharacter pparameter)
{
  sprintf(Buffer, "%c%c%c %s %s", TOKEN_RESPONSE, source, target, pcommand, presult, pparameter);
  return Buffer;
}


//
const char* Format(const char* mask, char* argument)
{
  sprintf(Buffer, mask, argument);
  return Buffer;
}
const char* Format(const char* mask, const char* argument)
{
  sprintf(Buffer, mask, argument);
  return Buffer;
}
const char* Format(const char* mask, Int32 argument)
{
  sprintf(Buffer, mask, argument);
  return Buffer;
}
const char* Format(const char* mask, UInt32 argument)
{
  sprintf(Buffer, mask, argument);
  return Buffer;
}
const char* Format(const char* mask, Float32 argument)
{
  sprintf(&Buffer[SIZE_BUFFER >> 1], "%d.%03d f", (int)argument, (int)(1000 * argument) % 1000);
  sprintf(Buffer, mask, &Buffer[SIZE_BUFFER >> 1]);
  return Buffer;
}
const char* Format(const char* mask, Double64 argument)
{
  sprintf(&Buffer[SIZE_BUFFER >> 1], "%d.%03d d", (int)argument, (int)(1000 * argument) % 1000);
  sprintf(Buffer, mask, &Buffer[SIZE_BUFFER >> 1]);
  return Buffer;
}
//
void Message(const char* message)
{
    UartCRB.TxLine(message);
}
void Warning(const char* warning)
{
    UartCRB.TxText("Warning: ");
    UartCRB.TxText(warning);
    UartCRB.TxLine(" !");
}
void Error(const char* error)
{
    UartCRB.TxText("Error: ");
    UartCRB.TxText(error);
    UartCRB.TxLine(" !");
}
void Debug(const char* debug)
{
    UartCRB.TxText("Debug: ");
    UartCRB.TxLine(debug);
}
void Debug(const char* mask, char* debug)
{    
    UartCRB.TxText("Debug: ");
    UartCRB.TxLine(Format(mask, debug));
}
void Debug(const char* mask, const char* debug)
{    
    UartCRB.TxText("Debug: ");
    UartCRB.TxLine(Format(mask, debug));
}
//
