//
#include "Servo.h"
//
CServo::CServo(TPin pinsignal, 
               TCB_Servo_OnStateChanged onstatechanged,
               TCB_Servo_OnSetPosition onsetposition)
{
    FPPwm = new CPulseWidthModulator(pinsignal);
    FOnStateChanged = onstatechanged;
    FOnSetPosition = onsetposition;
    FState = ssUndefined;
    FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, PERCENT_MIDDLE);
}
//
void CServo::SetState(EStateServo state)
{
    if (state != FState)
    {
        FState = state;
        switch (FState)
        {
            case ssPosition:
                break;
            default: // ssUndefined:
                break;
        }
        if (NULL != FOnStateChanged)
        {
            FOnStateChanged(FState);
        }
    }
}
//
Boolean CServo::Open(TPercent pwm)
{
    SetState(ssPosition);
    SetPosition(pwm);
    return true;
}
//
Boolean CServo::Close(void)
{
    SetState(ssUndefined);
    SetMiddle();
    return true;
}
//
void CServo::SetPosition(TPercent pwm)
{
    if (pwm != FPWM)
    {
        FPWM = (int)(0.5 + pwm);
        FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, FPWM);
        if (NULL != FOnSetPosition)
        {
            FOnSetPosition(pwm);
        }
    }
}
void CServo::SetLow(void)
{
  FPWM = (int)(0.5 + PERCENT_MINIMUM);
  FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, FPWM);
}
void CServo::SetMiddle(void)
{
  FPWM = (int)(0.5 + (PERCENT_MAXIMUM - PERCENT_MINIMUM) / 2.0);
  FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, FPWM);
}
void CServo::SetHigh(void)
{
  FPWM = (int)(0.5 + PERCENT_MAXIMUM);
  FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, FPWM);
}
//