//
#include "Led.h"
//
CLed::CLed(TPin pin, Boolean inverted, TCB_Led_OnStateChanged onstatechanged)
{
    FPin = pin;
    FInverted = inverted;
    FOnStateChanged = onstatechanged;
    FState = slUndefined;
}
//
void CLed::SetState(EStateLed state)
{
    if (state != FState)
    {
        FState = state;
        if (NULL != FOnStateChanged)
        {
            FOnStateChanged(FState);
        }
    }
}
//
Boolean CLed::Open(void)
{
    pinMode(FPin, OUTPUT);
    SetOff();
    return true;
}
Boolean CLed::Close(void)
{
    SetOff();
    pinMode(FPin, INPUT);
    return true;
}
//
void CLed::SetOn(void)
{
    if (FInverted)
    {
        digitalWrite(FPin, LOW);
    }
    else
    {
        digitalWrite(FPin, HIGH);
    }
    SetState(slOn);
}
void CLed::SetOff(void)
{
    if (FInverted)
    {
        digitalWrite(FPin, HIGH);
    }
    else
    {
        digitalWrite(FPin, LOW);
    }
    SetState(slOff);
}

