//
#include "Define.h"
//
#ifndef Motor_h
#define Motor_h
//
#include "PulseWidthModulator.h"
//
const int FREQUENCY_MOTOR = 20000; // [Hz]
//
enum EStateMotor
{
    smUndefined = -1,
    smIdle = 0,
    smPositive = 1,
    smNegative = 2
};
//
typedef void (*TCB_Motor_OnStateChanged)(EStateMotor state);
typedef void (*TCB_Motor_OnVelocityChanged)(TPercent pwm);
//
class CMotor
{
    private:
    EStateMotor FState;
    CPulseWidthModulator* FPPwmA;
    CPulseWidthModulator* FPPwmB;

    TCB_Motor_OnStateChanged FOnStateChanged;
    TCB_Motor_OnVelocityChanged FOnVelocityChanged;
    //
    public:
    CMotor(TPin pindirectiona, TPin pindirectionb,
           TCB_Motor_OnStateChanged onstatechanged,
           TCB_Motor_OnVelocityChanged onvelocitychanged);
    //
    void SetState(EStateMotor state);
    //
    Boolean Open(void);
    Boolean Close(void);
    //
    void MovePositive(TPercent pwm);
    void MoveNegative(TPercent pwm);
    void ForceHalt(void);
    void FreeRun(void);
 };
//
#endif // Motor_h
//
