//
#include "Define.h"
//
#include "Dispatcher.h"
//
extern PCharacter Buffer;
//
//------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------
CDispatcher::CDispatcher(// UartCRB
                         TCB_Uart_OnTxLine uartcrbontxline,
                         // LedSystem
                         TCB_Led_OnSetOn ledsystemonseton,
                         TCB_Led_OnSetOff ledsystemonsetoff,
                         // MotorLeft
                         TCB_Motor_OnMovePositive motorleftonmovepositive,
                         TCB_Motor_OnMoveNegative motorleftonmovenegative,
                         TCB_Motor_OnFreeRun motorleftonfreerun,
                         TCB_Motor_OnForceHalt motorleftonforcehalt,
                         // MotorRight
                         TCB_Motor_OnMovePositive motorrightonmovepositive,
                         TCB_Motor_OnMoveNegative motorrightonmovenegative,
                         TCB_Motor_OnFreeRun motorrightonfreerun,
                         TCB_Motor_OnForceHalt motorrightonforcehalt,
                         // ServoLeft
                         TCB_Servo_OnSetPosition servoleftonsetposition,
                         TCB_Servo_OnSetLow servoleftonsetlow,
                         TCB_Servo_OnSetMiddle servoleftonsetmiddle,
                         TCB_Servo_OnSetHigh servoleftonsethigh,
                         // ServoRight
                         TCB_Servo_OnSetPosition servorightonsetposition,
                         TCB_Servo_OnSetLow servorightonsetlow,
                         TCB_Servo_OnSetMiddle servorightonsetmiddle,
                         TCB_Servo_OnSetHigh servorightonsethigh)
{   // UartCRB
    FUartCRBOnTxLine = uartcrbontxline;
    // LedSystem
    FLedSystemOnSetOn = ledsystemonseton;
    FLedSystemOnSetOff = ledsystemonsetoff;
    // MotorLeft
    FMotorLeftOnMovePositive = motorleftonmovepositive;
    FMotorLeftOnMoveNegative = motorleftonmovenegative;
    FMotorLeftOnFreeRun = motorleftonfreerun;
    FMotorLeftOnForceHalt = motorleftonforcehalt;
    // MotorRight
    FMotorRightOnMovePositive = motorrightonmovepositive;
    FMotorRightOnMoveNegative = motorrightonmovenegative;
    FMotorRightOnFreeRun = motorrightonfreerun;
    FMotorRightOnForceHalt = motorrightonforcehalt;
    // ServoLeft
    FServoLeftOnSetPosition = servoleftonsetposition;
    FServoLeftOnSetLow = servoleftonsetlow;
    FServoLeftOnSetMiddle = servoleftonsetmiddle;
    FServoLeftOnSetHigh = servoleftonsethigh;
    // ServoRight
    FServoRightOnSetPosition = servorightonsetposition;
    FServoRightOnSetLow = servorightonsetlow;
    FServoRightOnSetMiddle = servorightonsetmiddle;
    FServoRightOnSetHigh = servorightonsethigh;
    //
    Initialise();
}
//
//------------------------------------------------------------------
// Property
//------------------------------------------------------------------
// Boolean CDispatcher::IsWaitingForCommandResponse(void)
// {
//     return (0 < FCommandResponse.length());
// }
//
//------------------------------------------------------------------
// Helper
//------------------------------------------------------------------
void CDispatcher::Initialise(void)
{
    FRxLines.Clear();
    FTxLines.Clear();
    FTxCommands.Clear();
    FEventAnalysed = "";
    FCommandResponse = "";
    FCounterResponse = 0;
}
//
void CDispatcher::ResetCommandResponse(void)
{
    FCommandResponse = "";
}
//
//------------------------------------------------------------------
// Transmit
//------------------------------------------------------------------
void CDispatcher::PushTxLine(PCCharacter txline)
{
    FTxLines.Push(txline);
}
//
void CDispatcher::PushTxCommand(PCCharacter txcommand)
{
    FTxCommands.Push(txcommand);
}
//
void CDispatcher::PushRxLine(String rxline)
{
    FRxLines.Push(rxline);
}

void  CDispatcher::PushTxEvent(PCCharacter txcommand)
{    
}
void  CDispatcher::PushTxEvent(Character source, Character target, PCCharacter text)
{    
    sprintf(Buffer, "%c%c%c %s", TOKEN_EVENT, source, target, text);
    FTxLines.Push(Buffer);
}
//
//------------------------------------------------------------------
// Receive
//------------------------------------------------------------------
Boolean CDispatcher::AnalyseResponse(Character source, Character target,
                                     PCCharacter pcommand, PCCharacter pparameter)
{
    return false;
}
//
Boolean CDispatcher::AnalyseEvent(Character source, Character target,
                                  PCCharacter pcommand, PCCharacter pparameter)
{
    PCCharacter TXL = BuildTxLine(TOKEN_EVENT, source, target, pcommand, pparameter);
    if (SYMBOL_SCRIPTOR == source)
    { // print('SCR: >>>AnalyseEvent:EventAround(ThisDevice)[{}]'.format(TXL))
        return true;
    }
    if (SYMBOL_SCRIPTOR == target)
    { // print('SCR: >>>AnalyseEvent:EventReachedTarget[{}]'.format(TXL))
        return true;
    }
    else // transmit to other devices
    {    // print('SCR: AnalyseEvent: Forward [{}]'.format(TXL))
        PushTxLine(TXL);
        return true;
    }
    return false;
}
//
Boolean CDispatcher::AnalyseCommand(Character source, Character target,
                                    PCCharacter pcommand, PCCharacter pparameter)
{   // LedSystem
    if (0 == strcmp(COMMAND_LEDSYSTEM_SETON, pcommand))
    {
        if (NULL != FLedSystemOnSetOn)
        {
            FLedSystemOnSetOn();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_LEDSYSTEM_SETOFF, pcommand))
    {
        if (NULL != FLedSystemOnSetOff)
        {
            FLedSystemOnSetOff();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    // MotorLeft
    if (0 == strcmp(COMMAND_MOTORLEFT_MOVEPOSITIVE, pcommand))
    {
        if (NULL != FMotorLeftOnMovePositive)
        {
            Float32 PWM = atof(pparameter);
            FMotorLeftOnMovePositive(PWM);
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_MOTORLEFT_MOVENEGATIVE, pcommand))
    {
        if (NULL != FMotorLeftOnMoveNegative)
        {
            Float32 PWM = atof(pparameter);
            FMotorLeftOnMoveNegative(PWM);
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_MOTORLEFT_FREERUN, pcommand))
    {
        if (NULL != FMotorLeftOnFreeRun)
        {
            FMotorLeftOnFreeRun();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_MOTORLEFT_FORCEHALT, pcommand))
    {
        if (NULL != FMotorLeftOnForceHalt)
        {
            FMotorLeftOnForceHalt();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    // MotorRight
    if (0 == strcmp(COMMAND_MOTORRIGHT_MOVEPOSITIVE, pcommand))
    {
        if (NULL != FMotorRightOnMovePositive)
        {
            Float32 PWM = atof(pparameter);
            FMotorRightOnMovePositive(PWM);
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_MOTORRIGHT_MOVENEGATIVE, pcommand))
    {
        if (NULL != FMotorRightOnMoveNegative)
        {
            Float32 PWM = atof(pparameter);
            FMotorRightOnMoveNegative(PWM);
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_MOTORRIGHT_FREERUN, pcommand))
    {
        if (NULL != FMotorRightOnFreeRun)
        {
            FMotorLeftOnForceHalt();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_MOTORRIGHT_FORCEHALT, pcommand))
    {
        if (NULL != FMotorRightOnForceHalt)
        {
            FMotorLeftOnForceHalt();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    // ServoLeft
    if (0 == strcmp(COMMAND_SERVOA_SETPOSITION, pcommand))
    {
        if (NULL != FServoLeftOnSetPosition)
        {
            Float32 PWM = atof(pparameter);
            FServoLeftOnSetPosition(PWM);
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_SERVOA_SETLOW, pcommand))
    {
        if (NULL != FServoLeftOnSetLow)
        {
            FServoLeftOnSetLow();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_SERVOA_SETMIDDLE, pcommand))
    {
        if (NULL != FServoLeftOnSetMiddle)
        {
            FServoLeftOnSetMiddle();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_SERVOA_SETHIGH, pcommand))
    {
        if (NULL != FServoLeftOnSetHigh)
        {
            FServoLeftOnSetHigh();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    // ServoRight
    if (0 == strcmp(COMMAND_SERVOB_SETPOSITION, pcommand))
    {
        if (NULL != FServoRightOnSetPosition)
        {
            Float32 PWM = atof(pparameter);
            FServoRightOnSetPosition(PWM);
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_SERVOB_SETLOW, pcommand))
    {
        if (NULL != FServoRightOnSetLow)
        {
            FServoRightOnSetLow();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_SERVOB_SETMIDDLE, pcommand))
    {
        if (NULL != FServoRightOnSetMiddle)
        {
            FServoRightOnSetMiddle();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    if (0 == strcmp(COMMAND_SERVOB_SETHIGH, pcommand))
    {
        if (NULL != FServoRightOnSetHigh)
        {
            FServoRightOnSetHigh();
            FTxLines.Push(ResponseTxdLine(source, target, pcommand, "1", pparameter));
            return true;
        }
    }
    return false;
}
//
Boolean CDispatcher::AnalyseRxLine(PCCharacter rxline)
{ // <@><s><t>< ><cmd>[< ><pi>|k]
    //  0  1  2  3  456   7  8
    int L = strlen(rxline);
    if (7 <= L)
    {
        ZeroBuffer();
        Character H = rxline[0];
        Character S = rxline[1];
        Character T = rxline[2];
        strncpy(Buffer, &(rxline[4]), 3);
        String *PC = new String(Buffer);
        String *PP = new String("");
        if (9 <= L)
        {
            strcpy(Buffer, &(rxline[8]));
            PP = new String(Buffer);
        }
#ifdef DEBUG
        SERIAL_PC.print("*** AnalyseRxLine: H[");
        SERIAL_PC.print(H);
        SERIAL_PC.print("]S[");
        SERIAL_PC.print(S);
        SERIAL_PC.print("]T[");
        SERIAL_PC.print(T);
        SERIAL_PC.print("]<");
        SERIAL_PC.print(PC->c_str());
        SERIAL_PC.print(">(");
        SERIAL_PC.print(PP->c_str());
        SERIAL_PC.println(")");
#endif
        if (TOKEN_COMMAND == H)
        {
            return AnalyseCommand(S, T, PC->c_str(), PP->c_str());
        }
        if (TOKEN_RESPONSE == H)
        {
            return AnalyseResponse(S, T, PC->c_str(), PP->c_str());
        }
        if (TOKEN_EVENT == H)
        {
            return AnalyseEvent(S, T, PC->c_str(), PP->c_str());
        }
    }
    return false;
}
//
Boolean CDispatcher::Open(void)
{
    Initialise();
    return true;
}
Boolean CDispatcher::Close(void)
{
    Initialise();
    return true;
}
void CDispatcher::Execute(void)
{
    if (0 < FRxLines.GetCount())
    {
        String RXL = FRxLines.Pop();
        AnalyseRxLine(RXL.c_str());
    }
    //
    if (0 < FTxLines.GetCount())
    {
        String TxLine = FTxLines.Pop();
        if (NULL != FUartCRBOnTxLine)
        {
            FUartCRBOnTxLine(TxLine);
        }
    }
    //
    if (0 < FTxCommands.GetCount())
    {
        // if (!IsWaitingForResponse())
        // {
        //     String TxC = self.TxCommands.Pop();
        //     AddTxCommand(TxC)
        // }
    }
    //
    return;
}
//-------------------------------------------------------------------
