#include "Define.h"
//
#ifndef CUart_h
#define CUart_h
//
#include <Arduino.h>
//
//--------------------------------------------------
//  Callback
//--------------------------------------------------
typedef void (*TCB_Uart_OnRxLine)(String rxline); 
typedef String (*TCB_Uart_OnTxLine)(String txline); 
//
//--------------------------------------------------
//  Uart
//--------------------------------------------------
class CUart
{
    private:
    HardwareSerial* FPSerial;
    int FBaudrate;
    TCB_Uart_OnRxLine FOnRxLine;
    TCB_Uart_OnTxLine FOnTxLine;
    String FRxLine;
    String FTxLine;
    public:
    CUart(HardwareSerial* pserial,
          int pinrxd, int pintxd,
          int baudrate,
          TCB_Uart_OnRxLine onrxline, 
          TCB_Uart_OnTxLine ontxline);
    //
    Boolean Open(void);
    Boolean Close(void);
    //
    Boolean TxText(PCCharacter txtext);
    Boolean TxText(PCharacter txtext);
    Boolean TxText(String txtext);
    Boolean TxLine(PCCharacter txline);
    Boolean TxLine(PCharacter txline);
    Boolean TxLine(String txline);
    //
    Boolean Execute(void);
};
//
#endif  // CUart_h
//