//
#ifndef Define_h
#define Define_h
//
#include <Arduino.h>
//
//-------------------------------------------------------
//  Types - STM32F103C8T6
//-------------------------------------------------------   
#define CONTROLLER_STM32F103C8T6
#ifdef CONTROLLER_STM32F103C8T6
//
#undef  DEBUG
//#define DEBUG
//
typedef char Character;
typedef const char CCharacter;
typedef char* PCharacter;
typedef const char* PCCharacter;
typedef bool Boolean;
//typedef String 
typedef int8_t Int8;
typedef uint8_t UInt8;
typedef int16_t Int16;
typedef uint16_t UInt16;
typedef int32_t Int32;
typedef uint32_t UInt32;
typedef int64_t Int64;
typedef uint64_t UInt64;
typedef float Float32;
typedef double Double64;
//
typedef float TPercent;
typedef int TPin;
//
//
const int PIN_LEDSYSTEM = PC13;
//
const int PIN_UARTCRB_RX = PB7;
const int PIN_UARTCRB_TX = PB6;
//
const int PIN_SERVOA_SIGNAL  = PB11;   // PWM2/4 - ServoAS
const int PIN_SERVOB_SIGNAL  = PB10;   // PWM2/3 - ServoBS
const int PIN_PWM_PB1   = PB1;    // PWM3/4 - MotorLA
const int PIN_PWM_PB0   = PB0;    // PWM3/3 - MotorLB
const int PIN_PWM_PA6   = PA6;    // PWM3/2 - MotorRA
const int PIN_PWM_PA7   = PA7;    // PWM3/1 - MotorRB
//
#endif // CONTROLLER_STM32F103C8T6
//
// ??? 2ndsolution #define BOARD_USART1_TX_PIN       PB6
// ??? 2ndsolution #define BOARD_USART1_RX_PIN       PB7

const int BAUDRATE_UARTPC = 115200;
//
const int FREQUENCY_ZERO = 0;      // [Hz]

const int MIN_PWM_SAS =  3; // [%]
const int MAX_PWM_SAS = 14; // [%]
const int MID_PWM_SAS =  6; // [%]
const int MIN_PWM_SBS =  3; // [%]
const int MAX_PWM_SBS = 14; // [%]
const int MID_PWM_SBS =  6; // [%]
const int MIN_PWM_MLA = 60; // [%]
const int MAX_PWMMLA = 100; // [%]
const int MIN_PWMMLB = 10; // [%]
const int MAX_PWMMLB = 90; // [%]
const int MIN_PWMMRA = 10; // [%]
const int MAX_PWMMRA = 90; // [%]
const int MIN_PWMMRB = 10; // [%]
const int MAX_PWMMRB = 90; // [%]


//
//-------------------------------------------------------
//  Helper
//-------------------------------------------------------   
void ZeroBuffer(void);
PCCharacter BuildTxLine(CCharacter header, CCharacter source, CCharacter target,
                        PCCharacter pcommand, PCCharacter pparameter);
PCCharacter ResponseTxdLine(CCharacter source, CCharacter target, 
                            PCCharacter pcommand, PCCharacter presult, PCCharacter pparameter);
//
//-------------------------------------------------------
//  Format
//-------------------------------------------------------   
const char* Format(const char* mask, char* argument);
const char* Format(const char* mask, const char* argument);
const char* Format(const char* mask, Int32 argument);
const char* Format(const char* mask, UInt32 argument);
const char* Format(const char* mask, Float32 argument);
const char* Format(const char* mask, Double64 argument);
//
//-------------------------------------------------------
//  Output
//-------------------------------------------------------   
void Message(const char* message);
void Warning(const char* warning);
void Error(const char* error);
void Debug(const char* debug);
void Debug(const char* mask, char* debug);
void Debug(const char* mask, const char* debug);
//
//-------------------------------------------------------
//  Ressources
//-------------------------------------------------------   
#define SYMBOL_ALL          (CCharacter)'A'
#define SYMBOL_COMMANDER    (CCharacter)'P'
#define SYMBOL_CONTROLLER   (CCharacter)'C'
#define SYMBOL_HARDWARE     (CCharacter)'H'
#define SYMBOL_SCRIPTOR     (CCharacter)'S'
#define SYMBOL_ESP32        (CCharacter)'E'
#define SYMBOL_STM32        (CCharacter)'T'
#define SYMBOL_REMOTER      (CCharacter)'R'
//
#define TOKEN_COMMAND       (CCharacter)'@'
#define TOKEN_RESPONSE      (CCharacter)'$'
#define TOKEN_EVENT         (CCharacter)'!'
#define TOKEN_COMMENT       (CCharacter)'#'
#define TOKEN_WARNING       (CCharacter)'.'
#define TOKEN_ERROR         (CCharacter)':'
//
//-------------------------------------------------------
//  Commands
//-------------------------------------------------------
#define COMMAND_LEDSYSTEM_SETON         (PCCharacter)"LSO"
#define COMMAND_LEDSYSTEM_SETOFF        (PCCharacter)"LSF"
//
#define COMMAND_MOTORLEFT_MOVEPOSITIVE  (PCCharacter)"MLP"
#define COMMAND_MOTORLEFT_MOVENEGATIVE  (PCCharacter)"MLN"
#define COMMAND_MOTORLEFT_FREERUN       (PCCharacter)"MLF"
#define COMMAND_MOTORLEFT_FORCEHALT     (PCCharacter)"MLH"
//
#define COMMAND_MOTORRIGHT_MOVEPOSITIVE (PCCharacter)"MRP"
#define COMMAND_MOTORRIGHT_MOVENEGATIVE (PCCharacter)"MRN"
#define COMMAND_MOTORRIGHT_FREERUN      (PCCharacter)"MRF"
#define COMMAND_MOTORRIGHT_FORCEHALT    (PCCharacter)"MRH"
//
#define COMMAND_SERVOA_SETPOSITION   (PCCharacter)"SAP"
#define COMMAND_SERVOA_SETLOW        (PCCharacter)"SAL"
#define COMMAND_SERVOA_SETMIDDLE     (PCCharacter)"SAM"
#define COMMAND_SERVOA_SETHIGH       (PCCharacter)"SAH"
//
#define COMMAND_SERVOB_SETPOSITION  (PCCharacter)"SBP"
#define COMMAND_SERVOB_SETLOW       (PCCharacter)"SBL"
#define COMMAND_SERVOB_SETMIDDLE    (PCCharacter)"SBM"
#define COMMAND_SERVOB_SETHIGH      (PCCharacter)"SBH"
//
#endif // Define_h
//