//
#include "Define.h"
//
#ifndef Dispatcher_h
#define Dispatcher_h
//
#include "Lines.h"
#include "Led.h"
#include "CUart.h"
#include "Motor.h"
#include "Servo.h"
//
typedef void (*TCB_Led_OnSetOn)(void);
typedef void (*TCB_Led_OnSetOff)(void);
//
typedef void (*TCB_Motor_OnMovePositive)(TPercent pwm);
typedef void (*TCB_Motor_OnMoveNegative)(TPercent pwm);
typedef void (*TCB_Motor_OnFreeRun)(void);
typedef void (*TCB_Motor_OnForceHalt)(void);
//
typedef void (*TCB_Servo_OnSetPosition)(TPercent pwm);
typedef void (*TCB_Servo_OnSetLow)(void);
typedef void (*TCB_Servo_OnSetMiddle)(void);
typedef void (*TCB_Servo_OnSetHigh)(void);
//
//--------------------------------------------------
//   Dispatcher
//--------------------------------------------------
class CDispatcher
{
    private:
    // UartPC
    TCB_Uart_OnTxLine FUartCRBOnTxLine;
    // LedSystem
    TCB_Led_OnSetOn FLedSystemOnSetOn;
    TCB_Led_OnSetOff FLedSystemOnSetOff;
    // MotorLeft
    TCB_Motor_OnMovePositive FMotorLeftOnMovePositive;
    TCB_Motor_OnMoveNegative FMotorLeftOnMoveNegative;
    TCB_Motor_OnFreeRun FMotorLeftOnFreeRun;
    TCB_Motor_OnForceHalt FMotorLeftOnForceHalt;
    // MotorRight
    TCB_Motor_OnMovePositive FMotorRightOnMovePositive;
    TCB_Motor_OnMoveNegative FMotorRightOnMoveNegative;
    TCB_Motor_OnFreeRun FMotorRightOnFreeRun;
    TCB_Motor_OnForceHalt FMotorRightOnForceHalt;
    // ServoLeft
    TCB_Servo_OnSetPosition FServoAOnSetPosition;
    TCB_Servo_OnSetLow FServoAOnSetLow;
    TCB_Servo_OnSetMiddle FServoAOnSetMiddle;
    TCB_Servo_OnSetHigh FServoAOnSetHigh;
    // ServoRight
    TCB_Servo_OnSetPosition FServoBOnSetPosition;
    TCB_Servo_OnSetLow FServoBOnSetLow;
    TCB_Servo_OnSetMiddle FServoBOnSetMiddle;
    TCB_Servo_OnSetHigh FServoBOnSetHigh;
    //
    CLines FRxLines;
    CLines FTxLines;
    CLines FTxCommands;
    String FEventAnalysed = "";
    String FCommandResponse = "";
    UInt8 FCounterResponse = 0;
    //
    public:
    //------------------------------------------------------------------
    // Constructor
    //------------------------------------------------------------------
    CDispatcher(// UartPC
                TCB_Uart_OnTxLine uartcrbontxline,  
                // LedSystem
                TCB_Led_OnSetOn ledsystemonseton, 
                TCB_Led_OnSetOff ledsystemonsetoff,
                // MotorLeft
                TCB_Motor_OnMovePositive motorleftonmovepositive,
                TCB_Motor_OnMoveNegative motorleftonmovenegative,
                TCB_Motor_OnFreeRun motorleftonfreerun,
                TCB_Motor_OnForceHalt motorleftonforcehalt,
                // MotorRight
                TCB_Motor_OnMovePositive motorrightonmovepositive, 
                TCB_Motor_OnMoveNegative motorrightonmovenegative, 
                TCB_Motor_OnFreeRun motorrightonfreerun,
                TCB_Motor_OnForceHalt motorrightonforcehalt,
                // ServoLeft
                TCB_Servo_OnSetPosition servoaonsetposition, 
                TCB_Servo_OnSetLow servoaonsetlow, 
                TCB_Servo_OnSetMiddle servoaonsetmiddle, 
                TCB_Servo_OnSetHigh servoaonsethigh, 
                // ServoRight
                TCB_Servo_OnSetPosition servobonsetposition,
                TCB_Servo_OnSetLow servobonsetlow, 
                TCB_Servo_OnSetMiddle servobonsetmiddle, 
                TCB_Servo_OnSetHigh servobonsethigh);
    //------------------------------------------------------------------
    // Property
    //------------------------------------------------------------------
    Boolean IsWaitingForCommandResponse(void);
    //------------------------------------------------------------------
    // Helper
    //------------------------------------------------------------------
    void Initialise(void);
    void ResetCommandResponse(void);
    //------------------------------------------------------------------
    // Handler
    //------------------------------------------------------------------
    Boolean Open(void);
    Boolean Close(void);
    void Execute(void);
    //------------------------------------------------------------------
    // Transmit
    //------------------------------------------------------------------
    void PushTxLine(PCCharacter txline);
    void PushTxCommand(PCCharacter txcommand);
    void PushTxEvent(PCCharacter txcommand);
    void PushTxEvent(Character source, Character target, PCCharacter text);//mask, Int32 number);
    //void PushTxEvent(Character source, Character target, PCCharacter mask, Float32 number);
    void PushRxLine(String rxline);
    Boolean AnalyseTxLine(PCCharacter txline);
    //------------------------------------------------------------------
    // Receive
    //------------------------------------------------------------------
    Boolean AnalyseResponse(Character source, Character target, 
                            PCCharacter pcommand, PCCharacter pparameter);
    Boolean AnalyseEvent(Character source, Character target, 
                         PCCharacter pcommand, PCCharacter pparameter);
    Boolean AnalyseCommand(Character source, Character target, 
                           PCCharacter pcommand, PCCharacter pparameter);
    Boolean AnalyseRxLine(PCCharacter rxline);
};


#endif // Dispatcher_h        