//
#include "Servo.h"
//
CServo::CServo(TPin pinsignal, 
               TCB_Servo_OnStateChanged onstatechanged,
               TCB_Servo_OnPositionChanged onpositionchanged)
{
    FPPwm = new CPulseWidthModulator(pinsignal);
    FOnStateChanged = onstatechanged;
    FOnPositionChanged = onpositionchanged;
    FState = ssUndefined;
    FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, MID_PWM_SBS);
}
//
void CServo::SetState(EStateServo state)
{
    if (state != FState)
    {
        FState = state;
        switch (FState)
        {
            case ssPosition:
                break;
            default: // ssUndefined:
                break;
        }
        if (NULL != FOnStateChanged)
        {
            FOnStateChanged(FState);
        }
    }
}
//
Boolean CServo::Open(TPercent pwm)
{
    SetState(ssPosition);
    SetPosition(pwm);
    return true;
}
//
Boolean CServo::Close(void)
{
    SetState(ssUndefined);
    SetMiddle();
    return true;
}
//
void CServo::SetPosition(TPercent pwm)
{
    if (pwm != FPWM)
    {
        FPWM = pwm;
        FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, (int)(0.5 + FPWM));
        if (NULL != FOnPositionChanged)
        {
            FOnPositionChanged(FPWM);
        }
    }
}
//
void CServo::SetLow(void)
{
  SetPosition(MIN_PWM_SBS);
}
void CServo::SetMiddle(void)
{
  SetPosition(MID_PWM_SBS);
}
void CServo::SetHigh(void)
{
  SetPosition(MAX_PWM_SBS);
}
//