//
#include "Define.h"
//
#ifndef Servo_h
#define Servo_h
//
#include "PulseWidthModulator.h"
//
const int FREQUENCY_SERVO = 50;    // [Hz]
//
enum EStateServo
{
    ssUndefined = -1,
    ssPosition = 0
};
//
typedef void (*TCB_Servo_OnStateChanged)(EStateServo state);
typedef void (*TCB_Servo_OnPositionChanged)(TPercent pwm);
//
class CServo
{
    private:
    EStateServo FState;
    CPulseWidthModulator* FPPwm;
    TPercent FPWM;
    TCB_Servo_OnStateChanged FOnStateChanged;
    TCB_Servo_OnPositionChanged FOnPositionChanged;
    //
    private:
    void SetState(EStateServo state);
    //
    public:
    CServo(TPin pinsignal, 
           TCB_Servo_OnStateChanged onstatechanged,
           TCB_Servo_OnPositionChanged onpositionchanged);
    //
    Boolean Open(TPercent pwm);
    Boolean Close(void);
    //
    void SetPosition(TPercent pwm);
    void SetLow(void);
    void SetMiddle(void);
    void SetHigh(void);
};
//
#endif // Servo_h
//
