//
#include "Define.h"
#include "CUart.h"
//
CUart::CUart(HardwareSerial* pserial,
             int pinrxd, int pintxd, 
             int baudrate,
             TCB_Uart_OnRxLine onrxline,
             TCB_Uart_OnTxLine ontxline)
{
    FPSerial = pserial;
    FBaudrate = baudrate;
    if (NULL == pserial)
    {
        FPSerial = new HardwareSerial(pinrxd, pintxd);
    }
    FOnRxLine = onrxline;
    FOnTxLine = ontxline;
    FRxLine = "";
    FTxLine = "";
}

//
//---------------------------------------------------------
Boolean CUart::Open(void)
{
    try
    {
        FRxLine = "";
        FTxLine = "";
        FPSerial->begin(FBaudrate);
        return true;
    }
    catch (int e)
    {
        Error("Close Uart failed");
        return false;
    }
}
//
Boolean CUart::Close(void)
{
    try
    {
        FRxLine = "";
        FTxLine = "";
        FPSerial->end();
        FPSerial = 0;
        return true;
    }
    catch (int e)
    {
        Error("Close Uart failed");
        return false;
    }
}
//
//---------------------------------------------------------
Boolean CUart::TxText(PCCharacter txtext)
{
    FPSerial->print(txtext);
    return true;
}
Boolean CUart::TxText(PCharacter txtext)
{
    FPSerial->print(txtext);
    return true;
}
Boolean CUart::TxText(String txtext)
{
    FPSerial->print(txtext.c_str());
    return true;
}
//
Boolean CUart::TxLine(PCCharacter txline)
{
    FPSerial->print(txline);
    FPSerial->print("\r\n");
    return true;
}
Boolean CUart::TxLine(PCharacter txline)
{
    FPSerial->print(txline);
    FPSerial->print("\r\n");
    return true;
}
Boolean CUart::TxLine(String txline)
{
    FPSerial->print(txline.c_str());
    FPSerial->print("\r\n");
    return true;
}
//
//---------------------------------------------------------
Boolean CUart::Execute(void)
{   // RxLine
    while (0 < FPSerial->available())
    {
        Character C = FPSerial->read();
        if (('\r' == C) | ('\n' == C))
        {
            if (0 < FRxLine.length())
            {
                FOnRxLine(FRxLine);
                // Debug("Uart.Execute: RxLine[%s]", FRxLine.c_str());
                FRxLine = "";
            }
        }
        else
        {
            FRxLine += C;
        }
    }
    // TxLine
    if (0 < FTxLine.length())
    {
        FTxLine = FOnTxLine(FTxLine);
        Debug("Uart.Execute: TxLine[%s]", FTxLine.c_str());
        FPSerial->print(FTxLine.c_str());
        FPSerial->print("\r\n");
        FTxLine = "";
    }            
    return false;
}

//