//
#include "Servo.h"
//
CServo::CServo(TPin pinsignal, 
               int pwmminimum, int pwmmaximum,
               TCB_Servo_OnStateChanged onstatechanged,
               TCB_Servo_OnPositionChanged onpositionchanged)
{
    FPPwm = new CPulseWidthModulator(pinsignal);
    FPwmMinimum = pwmminimum;
    FPwmMaximum = pwmmaximum;
    FOnStateChanged = onstatechanged;
    FOnPositionChanged = onpositionchanged;
    FState = ssUndefined;
    SetMiddle();
}
//
void CServo::SetState(EStateServo state)
{
    if (state != FState)
    {
        FState = state;
        switch (FState)
        {
            case ssPosition:
                break;
            default: // ssUndefined:
                break;
        }
        if (NULL != FOnStateChanged)
        {
            FOnStateChanged(FState);
        }
    }
}
//
Boolean CServo::Open(TPercent pwm)
{
    SetState(ssPosition);
    SetPosition(pwm);
    return true;
}
//
Boolean CServo::Close(void)
{
    SetState(ssUndefined);
    SetMiddle();
    return true;
}
//
//
void CServo::SetPosition(TPercent pwm)
{
    if (pwm != FPWM)
    {
        FPWM = pwm;
        int SP = ServoPercentPwm(FPWM, FPwmMinimum, FPwmMaximum);
        FPPwm->SetFrequencyPwm(FREQUENCY_SERVO, SP);
        if (NULL != FOnPositionChanged)
        {
            FOnPositionChanged(FPWM);
        }
    }
}
//
void CServo::SetLow(void)
{
  SetPosition(PERCENT_MINIMUM);
}
void CServo::SetMiddle(void)
{
  SetPosition(PERCENT_MIDDLE);
}
void CServo::SetHigh(void)
{
  SetPosition(PERCENT_MAXIMUM);
}
//