#
import sys
import time as TIM
import runpy
import serial as SER
#
import Define as DEF
import Thread as THR
import Lines as LIN
import Uart as UAR
#
#--------------------------------------------------
#   Dispatcher
#--------------------------------------------------
class CDispatcher():
    #---------------------------------------------------------    
    #   Constructor
    #---------------------------------------------------------
    def __init__(self,
                 ledsystem_seton, ledsystem_setoff,
                 motorl_moveforward, motorl_movebackward, 
                 motorl_freerun, motorl_forcehalt,
                 motorr_moveforward, motorr_movebackward, 
                 motorr_freerun, motorr_forcehalt,
                 servoa_setposition, servoa_setlow,
                 servoa_setmedium, servoa_sethigh,
                 servob_setposition, servob_setlow,
                 servob_setmedium, servob_sethigh):        
        self.LedSystem_SetOn = ledsystem_seton
        self.LedSystem_SetOff = ledsystem_setoff
        self.MotorL_MoveForward = motorl_moveforward
        self.MotorL_MoveBackward = motorl_movebackward 
        self.MotorL_FreeRun = motorl_freerun
        self.MotorL_ForceHalt = motorl_forcehalt
        self.MotorR_MoveForward = motorr_moveforward
        self.MotorR_MoveBackward= motorr_movebackward 
        self.MotorR_FreeRun = motorr_freerun
        self.MotorR_ForceHalt = motorr_forcehalt
        self.ServoA_SetPosition = servoa_setposition
        self.ServoA_SetLow = servoa_setlow
        self.ServoA_SetMedium = servoa_setmedium
        self.ServoA_SetHigh = servoa_sethigh
        self.ServoB_SetPosition = servob_setposition 
        self.ServoB_SetLow = servob_setlow
        self.ServoB_SetMedium = servob_setmedium
        self.ServoB_SetHigh = servob_sethigh
        #
        self.EventAnalysed = ''
        self.RxLines = LIN.CLines()
        self.TxLines = LIN.CLines()
        self.Commands = LIN.CLines()
        self.CommandPushed = False
        self.CommandResponse = ''
        self.Thread = THR.CThread('THR', 
                                  self.OnStart, self.OnBusy, 
                                  self.OnAbort, self.OnEnd)
        self.CounterResponse = 0
        #
        self.RxResult = False
        self.RxParameter = ''
        
        return
    #---------------------------------------------------------    
    #   Property
    #---------------------------------------------------------
    def GetRxResult(self):
        return self.RxResult
    def GetRxParameter(self):
        return self.RxParameter
        #    
    #---------------------------------------------------------    
    #   Callback - Thread
    #---------------------------------------------------------
    def OnStart(self, thread):
        # debug print('{}: Thread_OnStart: begin'.format(self.ID))
        self.RxLines.clear()
        self.TxLines.clear()
        self.Commands.clear()
        self.ResetCommandPushedResponse()
        return
    #
    def OnBusy(self, thread):
        # RxLines
        if (0 < self.RxLines.Count()):
            RXL = self.RxLines.Pop()
            #debug print('~~~RMT-RXL~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~')
            #debug print('SCR: OnBusy: RXL[{}]'.format(RXL))
            self.AnalyseRxLine(RXL)
        # TxLines
        if (0 < self.TxLines.Count()):
            TXL = self.TxLines.Pop()
            #debug print('~~~RMT-TXL~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~')
            #debug print('SCR: OnBusy: TXL[{}]'.format(TXL))
            self.AnalyseTxLine(TXL)
        # Commands
        if (0 < self.Commands.Count()):
            if not(self.IsWaitingForCommandResponse()):                
                Command = self.Commands.Pop()
                self.SetCommandResponseActive(Command)
                if (7 <= len(Command)):
                    H = Command[0]
                    S = Command[1]
                    T = Command[2]
                    C = Command[4:7]
                    P = Command[8:]
                    print('++++++++++++++++++++++++++++++++++++++++++++++')
                    self.AnalyseCommand(S, T, C, P) 
        #
        TIM.sleep(0.001) 
        return (thread.Loop)
    #
    def OnAbort(self, thread):
        # debug print('{}: Thread_OnAbort: begin'.format(self.ID))
        self.RxLines.clear()
        self.TxLines.clear()
        self.Commands.clear()
        self.ResetCommandPushedResponse()
        return
    #
    def OnEnd(self, thread):
        # debug print('{}: Thread_OnEnd: begin'.format(self.ID))
        self.RxLines.clear()
        self.TxLines.clear()
        self.Commands.clear()
        self.ResetCommandPushedResponse()
        return
    #
    #---------------------------------------------------------    
    #   Helper
    #---------------------------------------------------------
    def ResetCommandPushedResponse(self):
        self.CounterResponse = 0        
        self.CommandResponse = ''
        self.CommandPushed = False
        return
    def SetCommandResponseActive(self, command):
        self.CommandResponse = command
        return
    def IsWaitingForCommandResponse(self):
        return (0 < len(self.CommandResponse))
    def IsCommandPushed(self):  
        return self.CommandPushed
    #
    def PushRxLine(self, rxline):
        self.RxLines.Push(rxline)
        return
    def PushTxLine(self, txline):
        self.TxLines.Push(txline)
        #debug print('___ PushTxLine[{}]<{}>'.format(len(self.TxLines), txline))
        return
    def PushCommand(self, commandline):
        self.Commands.Push(commandline)
        self.CommandPushed = True
        self.CommandResponse = ''
        #debug 
        print('***PushCommand[{}]'.format(commandline))
        return
    #    
    #
    #
    #---------------------------------------------------------    
    #   Handler
    #---------------------------------------------------------
    def Open(self):
        self.Thread.Start()
        return True
    def Close(self):        
        self.Thread.Abort()
        return True
    #
    
    
    
    
    
    #---------------------------------------------------------    
    #   Helper
    #---------------------------------------------------------   
    def AnalyseCommand(self, source, target, command, parameters):
        # debug 
        print('AnalyseCommand[{}|{}]<{}><{}>'.format(source, target, command, parameters))
        RXL = DEF.BuildTxLine(DEF.TOKEN_RESPONSE, source, target, command, parameters)
        if (DEF.SYMBOL_REMOTER == target): # P
            if (DEF.COMMAND_LEDSYSTEM_SETON == command):
                if (None != self.LedSystem_SetOn):
                    self.LedSystem_SetOn()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_LEDSYSTEM_SETOFF == command):
                if (None != self.LedSystem_SetOff):
                    self.LedSystem_SetOff()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_MOTOR_MOVEFORWARD == command):
                if (None != self.Motor_MoveForward):
                    self.Motor_MoveForward()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_MOTOR_MOVEBACKWARD == command):
                if (None != self.Motor_MoveBackward):
                    self.Motor_MoveBackward()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_MOTOR_ABORTMOTION == command):
                if (None != self.Motor_AbortMotion):
                    self.Motor_AbortMotion()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_FILE_READLINE == command):
                if (None != self.File_ReadLine):
                    self.File_ReadLine()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_FILE_CLOSEREAD == command):
                if (None != self.File_CloseRead):
                    self.File_CloseRead()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_FILE_CLOSEWRITE == command):
                if (None != self.File_CloseRead):
                    self.File_CloseWrite()
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_FILE_OPENREAD == command):
                if (None != self.File_OpenRead):
                    self.File_OpenRead(parameters)
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_FILE_OPENWRITE == command):
                if (None != self.File_OpenWrite):
                    self.File_OpenWrite(parameters)
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            if (DEF.COMMAND_FILE_WRITELINE == command):
                if (None != self.File_WriteLine):
                    self.File_WriteLine(parameters)
                    self.AnalyseRxLine(RXL)
                    return True             
                return False                    
            return False
        else: # forward to target:
            TXL = DEF.BuildTxLine(DEF.TOKEN_COMMAND, source, target, command, parameters)
            #debug print('Forwarding[{}]'.format(TXL))
            self.TxLines.Push(TXL)
        return True
    #
    def AnalyseResponse(self, source, target, command, parameter):
        print('***AnalyseResponse S[{}]T[{}]<{}><{}>'.format(source, target, command, parameter))
        if (DEF.SYMBOL_REMOTER == source): # == C
            #debug print('RMT: >>>CommandResponse[{}]-[{}]'.format(self.CommandResponse, tokens))
            #debug print('RMT: >>>CommandResponse[{}] completed'.format(self.CommandResponse))
            if (DEF.SYMBOL_SCRIPTOR == target):
                if (DEF.COMMAND_MFS_OPENREAD == command):
                    self.RxResult = DEF.ParameterResult(parameter)
                    self.RxParameter = DEF.ParameterExtract(parameter)
                elif (DEF.COMMAND_MFS_READLINE == command):
                    self.RxResult = DEF.ParameterResult(parameter)
                    self.RxParameter = DEF.ParameterExtract(parameter)
                elif (DEF.COMMAND_MFS_CLOSEREAD == command):
                    self.RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_CFS_OPENREAD == command):
                    self.RxResult = DEF.ParameterResult(parameter)
                    self.RxParameter = DEF.ParameterExtract(parameter)
                elif (DEF.COMMAND_CFS_READLINE == command):
                    self.RxResult = DEF.ParameterResult(parameter)
                    self.RxParameter = DEF.ParameterExtract(parameter)
                elif (DEF.COMMAND_CFS_CLOSEREAD == command):
                    self.RxResult = DEF.ParameterResult(parameter)
            self.ResetCommandPushedResponse() # HS completed -> send of new commands possible
            print('----------------------------------------------')
            return True
        # != C -> forward to P, H, S!!!
        TXL = DEF.BuildTxLine(DEF.TOKEN_RESPONSE, source, target, command, parameters)
        self.TxLines.Push(TXL)        
        #debug print('RMT: AnalyseResponse: Forward [{}]'.format(TXL))
        return True
    #
    def AnalyseEvent(self, source, target, command, parameters):
        #debug print('AnalyseEvent: S[{}]T[{}]T[{}]'.format(source, target, command, parameters))
        TXL = DEF.BuildTxLine(DEF.TOKEN_EVENT, source, target, command, parameters)
        if (DEF.SYMBOL_REMOTER == source):
            #debug print('AnalyseEvent:EventAround(ThisDevice)[{}]'.format(TXL))
            pass
        elif (DEF.SYMBOL_REMOTER == target):
            #debug print('AnalyseEvent:EventReachedTarget[{}]'.format(TXL))
            pass
        else: # transmit to other devices
            #debug print('AnalyseEvent: Forward [{}]'.format(TXL))
            self.PushTxLine(TXL)
        return True
    #
    def AnalyseRxLine(self, rxline):
        # <@><s><t>< ><cmd>[< ><pi>|k]
        if (7 <= len(rxline)):
            H = rxline[0]
            S = rxline[1]
            T = rxline[2]
            C = rxline[4:7]
            P = rxline[8:]
    # debug print('***AnalyseRxLine: H[{}] S[{}] T[{}] C[{}] P[{}]'.format(H, S, T, C, P))
            if (DEF.TOKEN_COMMAND == H):
                return self.AnalyseCommand(S, T, C, P)
            if (DEF.TOKEN_RESPONSE == H):
                return self.AnalyseResponse(S, T, C, P)
            if (DEF.TOKEN_EVENT == H):
                return self.AnalyseEvent(S, T, C, P)
        return False
    
#    
    
    
#