#
import sys
import time as TIM
import subprocess
from PyQt6 import QtWidgets
from PyQt6.QtWidgets import QFileDialog
from PyQt6.QtGui import *
#
import Define as DEF
import Uart as UAR
import Lines as LIN
import Thread as THR
#
import CPCLedSystem as CPCLS
import CPCMotor as CPCM
import CPCServo as CPCS
#
import Dispatcher as DSP
import WNDRemoter as WND
#
Script = ''
#
#---------------------------------------------------------    
#   Callback - UartCB
#---------------------------------------------------------
def UartCRB_OnRxLine(rxline):
    DEF.Message('UartCRB_OnRxLine[{}]'.format(rxline))
    #!!!Dispatcher.PushRxLine(rxline) # Rx: UartCRB -> Dispatcher
    #!!!WindowMain.ProtocolRxLine('UartCRB', rxline) 
    return
def UartCRB_OnTxLine(txline): 
    DEF.Message('UartCRB_OnTxLine[{}]'.format(txline))
    #!!!WindowMain.ProtocolTxLine('UartCRB', txline)
    return txline # !return value changed txline!
#
def GUI_UartCRB_Open(comport, baudrate):
    DEF.Message('GUI_UartCRB_Open[{}][{}]'.format(comport, baudrate))
    UartCRB.Open(comport, baudrate)
    return True
def GUI_UartCRB_Close():
    DEF.Message('GUI_UartCRB_Close[]')
    UartCRB.Close()
    return True
#
#-------------------------------------------------------------------------------
#   Action/Event - LedSystem - Remoter/Scriptor
#-------------------------------------------------------------------------------
def LedSystem_OnStateChanged(state):
    print('LedSystem_OnStateChanged')
    # TXL = DEF.BuildTxLine(DEF.TOKEN_EVENT, DEF.SYMBOL_REMOTER, 
    #                       DEF.SYMBOL_ALL, DEF.MASK_LEDSYSTEM_STATE.format(state))
    # #debug print('SCR: >>>LedSystem_OnStateChanged[{}]'.format(TXL))
    # Dispatcher.PushTxLine(TXL)
    # WindowMain.LedSystemSetState(state)
    return
#
def DSP_LedSystem_SetOn():
    print('DSP_LedSystem_SetOn')
    #debug print('### SetOn')
    #LedSystem.SetOn()
    return
def DSP_LedSystem_SetOff():
    print('DSP_LedSystem_SetOff')
    #debug print('### SetOff')
    #LedSystem.SetOff()
    return
#
def GUI_LedSystem_SetOn():
    print('GUI_LedSystem_SetOn')
    # TXL = DEF.BuildTxLine(DEF.TOKEN_COMMAND, DEF.SYMBOL_REMOTER,
    #                       DEF.SYMBOL_REMOTER, DEF.COMMAND_LEDSYSTEM_SETON)
    # Dispatcher.PushCommand(TXL)
    return    
def GUI_LedSystem_SetOff():
    print('GUI_LedSystem_SetOff')
    # TXL = DEF.BuildTxLine(DEF.TOKEN_COMMAND, DEF.SYMBOL_REMOTER,
    #                       DEF.SYMBOL_REMOTER, DEF.COMMAND_LEDSYSTEM_SETOFF)
    # Dispatcher.PushCommand(TXL)
    return
#
#-------------------------------------------------------------------------------
#   Action/Event - Motor - L
#-------------------------------------------------------------------------------
def MotorL_OnStateChanged(state):
    # print('Motor: OnStateChanged[{}]'.format(Motor.GetStateText()))
    # WindowMain.SetMotorStateText(Motor.GetStateText())
    return
def MotorL_OnVelocityChanged(position):
    return
#
def DSP_MotorL_MoveForward(position):
    #debug print('Motor: MoveForward[]')
    ##Motor.MoveForward()
    #debug WindowMain.SetMotorStateText(Motor.GetStateText())
    # print('Motor: OnMoveForward[]')
    # CMD = DEF.BuildTxLine(DEF.TOKEN_COMMAND, DEF.SYMBOL_REMOTER,
    #                       DEF.SYMBOL_REMOTER, DEF.COMMAND_MOTOR_MOVEFORWARD)
    # Dispatcher.PushCommand(CMD)
    return
def DSP_MotorL_MoveBackward(position):
    #debug print('Motor: MoveBackward[]')
    #Motor.MoveBackward()
    #debug WindowMain.SetMotorStateText(Motor.GetStateText())
    # print('Motor: OnMoveBackward[]')
    # CMD = DEF.BuildTxLine(DEF.TOKEN_COMMAND, DEF.SYMBOL_REMOTER,
    #                       DEF.SYMBOL_REMOTER, DEF.COMMAND_MOTOR_MOVEBACKWARD)
    # Dispatcher.PushCommand(CMD)
    return
def DSP_MotorL_FreeRun():
    #debug print('Motor: AbortMotion[]')
    #Motor.AbortMotion()
    #debug WindowMain.SetMotorStateText(Motor.GetStateText())
    # print('Motor: OnAbortMotion[]')
    # CMD = DEF.BuildTxLine(DEF.TOKEN_COMMAND, DEF.SYMBOL_REMOTER,
    #                       DEF.SYMBOL_REMOTER, [DEF.COMMAND_MOTOR_ABORTMOTION])
    # Dispatcher.PushCommand(CMD)
    return
def DSP_MotorL_ForceHalt():
    return
#
def GUI_MotorL_MoveForward(position):
    return
def GUI_MotorL_MoveBackward(position):
    return
def GUI_MotorL_FreeRun():
    return
def GUI_MotorL_ForceHalt():
    return
#
#-------------------------------------------------------------------------------
#   Action/Event - Motor - R
#-------------------------------------------------------------------------------
def MotorR_OnStateChanged(state):
    return
def MotorR_OnVelocityChanged(position):
    return
#
def DSP_MotorR_MoveForward(position):
    return
def DSP_MotorR_MoveBackward(position):
    return
def DSP_MotorR_FreeRun():
    return
def DSP_MotorR_ForceHalt():
    return
#
def GUI_MotorR_MoveForward(position):
    return
def GUI_MotorR_MoveBackward(position):
    return
def GUI_MotorR_FreeRun():
    return
def GUI_MotorR_ForceHalt():
    return
#
#-------------------------------------------------------------------------------
#   Action/Event - Servo - A
#-------------------------------------------------------------------------------
def ServoA_OnStateChanged(state):
    return
def ServoA_OnPositionChanged(position):
    return
#
def DSP_ServoA_SetPosition(position):
    return
def DSP_ServoA_SetLow():
    return
def DSP_ServoA_SetMedium():
    return
def DSP_ServoA_SetHigh():
    return
#
def GUI_ServoA_SetPosition(position):
    return
def GUI_ServoA_SetLow():
    return
def GUI_ServoA_SetMedium():
    return
def GUI_ServoA_SetHigh():
    return
#
#-------------------------------------------------------------------------------
#   Action/Event - Servo - B
#-------------------------------------------------------------------------------
def ServoB_OnStateChanged(state):
    return
def ServoB_OnPositionChanged(position):
    return
#
def DSP_ServoB_SetPosition(position):
    return
def DSP_ServoB_SetLow():
    return
def DSP_ServoB_SetMedium():
    return
def DSP_ServoB_SetHigh():
    return
#
def GUI_ServoB_SetPosition(position):
    return
def GUI_ServoB_SetLow():
    return
def GUI_ServoB_SetMedium():
    return
def GUI_ServoB_SetHigh():
    return
#
#--------------------------------------------------
#   Main
#--------------------------------------------------
if ('__main__' == __name__):
    #try:
    print('*** PcSCDScriptor: begin')
    #
    UartCRB = UAR.CUart('UartCRB', UartCRB_OnRxLine, UartCRB_OnTxLine) 
    Dispatcher = DSP.CDispatcher(DSP_LedSystem_SetOn, DSP_LedSystem_SetOff,
                                 DSP_MotorL_MoveForward, DSP_MotorL_MoveBackward,
                                 DSP_MotorL_FreeRun, DSP_MotorL_ForceHalt,
                                 DSP_MotorR_MoveForward, DSP_MotorR_MoveBackward,
                                 DSP_MotorR_FreeRun, DSP_MotorR_ForceHalt,
                                 DSP_ServoA_SetPosition, DSP_ServoA_SetLow,
                                 DSP_ServoA_SetMedium, DSP_ServoA_SetHigh,
                                 DSP_ServoB_SetPosition, DSP_ServoB_SetLow,
                                 DSP_ServoB_SetMedium, DSP_ServoB_SetHigh)
    #
    A = QtWidgets.QApplication(sys.argv)
    WindowMain = WND.CWNDRemoter(GUI_UartCRB_Open, GUI_UartCRB_Close,
                                 GUI_LedSystem_SetOn, GUI_LedSystem_SetOff,
                                 GUI_MotorL_MoveForward, GUI_MotorL_MoveBackward,
                                 GUI_MotorL_FreeRun, GUI_MotorL_ForceHalt,
                                 GUI_MotorR_MoveForward, GUI_MotorR_MoveBackward,
                                 GUI_MotorR_FreeRun, GUI_MotorR_ForceHalt,
                                 GUI_ServoA_SetPosition, GUI_ServoA_SetLow,
                                 GUI_ServoA_SetMedium, GUI_ServoA_SetHigh,
                                 GUI_ServoB_SetPosition, GUI_ServoB_SetLow,
                                 GUI_ServoB_SetMedium, GUI_ServoB_SetHigh)
    #
    LedSystem = CPCLS.CLedSystem(LedSystem_OnStateChanged)
    MotorL = CPCM.CMotor(MotorL_OnStateChanged, MotorL_OnVelocityChanged)
    MotorR = CPCM.CMotor(MotorR_OnStateChanged, MotorR_OnVelocityChanged)
    ServoA = CPCS.CServo(ServoA_OnStateChanged, ServoA_OnPositionChanged)
    ServoB = CPCS.CServo(ServoB_OnStateChanged, ServoB_OnPositionChanged)
    #
    #WindowMain.RefreshComPortsAvailable()
    #WindowMain.OpenUartCRB(DEF.COMPORT_REMOTER, DEF.BAUDRATE_DISPATCHER)
    #
    WindowMain.Open()
    WindowMain.PositionSize(-750, 10, 746, 680)
    WindowMain.show() 
    # ??? Script_LoadDefaultFile()
    #
    Dispatcher.Open()
    #    
    A.exec()
    #
    UartCRB.Close()
    Dispatcher.Close()    
    WindowMain.Close()
    #
    print('*** PcSCDScriptor: end')
    # except:
    #     pass    
    # finally:
        # UartCBUC.Close()
        # Dispatcher.Close()
        # WindowMain.Close()
        # pass
    
#



