#
#COMPORT_COMMANDER   = 'COM32'
#COMPORT_CONTROLLER  = 'COM33'
#COMPORT_HARDWARE    = 'COM34'
#COMPORT_SCRIPTOR    = 'COM55'
#COMPORT_REMOTER      = 'COM55'
COMPORT_REMOTER      = 'COM50'
#
BAUDRATE_DISPATCHER = '115200'
#
#DEBUG_DISPATCHERCOMMANDER   = False
#DEBUG_DISPATCHERCONTROLLER  = False
#DEBUG_DISPATCHERHARDWARE    = False
DEBUG_DISPATCHERSCRIPTOR    = False
DEBUG_LEDSYSTEM             = False
#
SYMBOL_ALL          = 'A'
SYMBOL_COMMANDER    = 'P'
SYMBOL_CONTROLLER   = 'C'
SYMBOL_HARDWARE     = 'H'
SYMBOL_SCRIPTOR     = 'S'
SYMBOL_ESP32        = 'E'
SYMBOL_REMOTER      = 'R'
#
TOKEN_COMMAND       = '@'
TOKEN_RESPONSE      = '$'
TOKEN_EVENT         = '!'
#TOKEN_COMMENT       = '#'
#TOKEN_WARNING       = '.'
#TOKEN_ERROR         = ':'
#
TEXT_COMMANDER  = '[P]-Commander'
TEXT_CONTROLLER = '[C]-Controller'
TEXT_HARDWARE   = '[H]-Hardware'
TEXT_SCRIPTOR   = '[S]-Scriptor'
TEXT_ESP32      = '[E]-Esp32'
TEXT_REMOTER    = '[R]-Remoter'
#
MASK_LEDSYSTEM_STATE        = 'SLS {}'
#
COMMAND_LEDSYSTEM_SETON     = 'LSO'
COMMAND_LEDSYSTEM_SETOFF    = 'LSF'
#
COMMAND_MOTOR_MOVEFORWARD   = 'MMF'
COMMAND_MOTOR_MOVEBACKWARD  = 'MMB'
COMMAND_MOTOR_ABORTMOTION   = 'MAM'
#
COMMAND_FILE_OPENREAD       = 'FOR'
COMMAND_FILE_READLINE       = 'FRL'
COMMAND_FILE_CLOSEREAD      = 'FCR'
COMMAND_FILE_OPENWRITE      = 'FOW'
COMMAND_FILE_WRITELINE      = 'FWL'
COMMAND_FILE_CLOSEWRITE     = 'FCW'
COMMAND_FILE_EXECUTEFILE    = 'FXF' # !!! implement !!!
# Commands: MFS
COMMAND_MFS_OPENWRITE       = 'MOW'
COMMAND_MFS_WRITELINE       = 'MWL'
COMMAND_MFS_CLOSEWRITE      = 'MCW'
COMMAND_MFS_OPENREAD        = 'MOR'
COMMAND_MFS_READLINE        = 'MRL'
COMMAND_MFS_CLOSEREAD       = 'MCR'
COMMAND_MFS_EXECUTEFILE     = 'MXF'
COMMAND_MFS_COPYTOCFS       = 'MCC' # !!! implement !!!
# Commands: CFS
COMMAND_CFS_OPENWRITE       = 'COW'
COMMAND_CFS_WRITELINE       = 'CWL'
COMMAND_CFS_CLOSEWRITE      = 'CCW'
COMMAND_CFS_OPENREAD        = 'COR'
COMMAND_CFS_READLINE        = 'CRL'
COMMAND_CFS_CLOSEREAD       = 'CCR'
COMMAND_CFS_EXECUTEFILE     = 'CXF'
COMMAND_CFS_COPYTOMFS       = 'CCM' # !!! implement !!!
#
import time as TIM
#
def Error(message, delay):
    print('Error: {}!'.format(message))
    TIM.sleep(delay)
    #
def BuildTxLine(header, source, target, command, parameters=''):
    if (0 < len(parameters)):
        TXL = '{}{}{} {} {}'.format(header, source, target, command, parameters)
    else:
        TXL = '{}{}{} {}'.format(header, source, target, command)
    return TXL
#
def ConvertSourceTargetCharacter(text):
    if (TEXT_COMMANDER == text):
        return 'P'
    if (TEXT_CONTROLLER == text):
        return 'C'
    if (TEXT_HARDWARE == text):
        return 'H'
    if (TEXT_SCRIPTOR == text):
        return 'S'
    if (TEXT_ESP32 == text):
        return 'E'
    if (TEXT_REMOTER == text):
        return 'R'
    return '?'
#
def ResultAppend(result):
    if (True == result):
        return ' 1' 
    return ' 0'
def ParameterResult(parameter):
    if ('1' == parameter[0]):
        return True
    return False
def ParameterExtract(parameter):
    return parameter[2:]
def ParameterAppend(parameter):
    return ' ' + parameter
#
def LinesText(lines):
    Text = ''
    for Line in lines:
        Text += Line + '\r\n'
    return Text
def TextLines(text):
    Lines = []
    Line = ''
    for C in text:
        if ('\r' == C) or ('\n' == C):
            if (0 < len(Line)):
                Lines.append(Line)
                Line = ''
        else:
            Line += C
    return Lines
#
#---------------------------------------------------------    
#   Helper - System
#---------------------------------------------------------
def Error(message):
    print('Error: {} !'.format(message))
def Warning(message):
    print('Warning: {} !'.format(message))
def Debug(message):
    print('Debug: {}'.format(message))
def Message(message):
    print('>{}'.format(message))
def Info(message):
    print(message)
#
