#
import time as TIM
import serial as SER
#
import Define as DEF
import Thread as THR
import Lines as LIN
#
DEBUG_UART = False
#
#--------------------------------------------------
#   Uart
#--------------------------------------------------
class CUart():
    #
    def __init__(self, id, onrxline, ontxline):
        self.ID = id
        self.Serial = None
        self.Comport = ''
        self.Baudrate = ''
        self.RxLines = LIN.CLines()
        self.TxLines = LIN.CLines()
        self.OnRxLine = onrxline
        self.OnTxLine = ontxline
        self.RxBuffer = ''
        self.Thread = THR.CThread(self.ID, 
                                  self.OnStart, self.OnBusy, 
                                  self.OnAbort, self.OnEnd)
    #---------------------------------------------------------    
    #   Callback - Thread
    #---------------------------------------------------------
    def OnStart(self, thread):
        if DEBUG_UART:
            print('{}: Thread_OnStart: begin'.format(self.ID))
        if (None != self.Serial):
            self.Serial.close()
        self.RxLines.clear()
        self.TxLines.clear()
        self.Serial = SER.Serial(self.Comport, self.Baudrate)
        if DEBUG_UART:
            print('{}: Thread_OnStart: end'.format(self.ID))
        return
    #
    def OnBusy(self, thread):
        #if DEBUG_UART:
        #    print('{}: Thread_OnBusy: begin'.format(self.ID))        
        if (None == self.Serial):
            return False
        if not(self.Serial.isOpen()):
            return False
        # RxData
        while (0 < self.Serial.in_waiting):
            C = self.Serial.read()
            if ((b'\r' == C) or (b'\n' == C)):
                if (0 < len(self.RxBuffer)):
                    if DEBUG_UART:
                        print('Rx[{}]'.format(self.RxBuffer))
                    self.RxLines.Push(self.RxBuffer)
                    self.RxBuffer = ''
            else:
                self.RxBuffer += C.decode('utf-8')
                if DEBUG_UART:
                    print(self.RxBuffer)
        # TxLines
        if (0 < self.TxLines.Count()):
            TxLine = self.TxLines.Pop()
            if (0 < len(TxLine)):
                TxLine = self.OnTxLine(TxLine) # add CR + LF !
                self.Serial.write(TxLine.encode()) # only here!            
        # RxLines
        if (0 < self.RxLines.Count()):
            RxLine = self.RxLines.Pop()
            if (0 < len(RxLine)):
                if (None != self.OnRxLine):
                    self.OnRxLine(RxLine)
        #if DEBUG_UART:
        #    print('{}: Thread_OnBusy: end'.format(self.ID))
        TIM.sleep(0.001)
        return (thread.Loop)
    #
    def OnAbort(self, thread):
        if DEBUG_UART:
            print('{}: Thread_OnAbort: begin'.format(self.ID))
        if (None != self.Serial):
            self.Serial.close()
        self.Serial = None
        self.TxLines.clear()
        if DEBUG_UART:
            print('{}: Thread_OnAbort: end'.format(self.ID))
        return
    def OnEnd(self, thread):
        if DEBUG_UART:
            print('{}: Thread_OnEnd: begin'.format(self.ID))
        if (None != self.Serial):
            self.Serial.close()
        self.Serial = None
        self.TxLines.clear()
        if DEBUG_UART:
            print('{}: Thread_OnEnd: end'.format(self.ID))
        return
    #---------------------------------------------------------    
    #   Manager
    #---------------------------------------------------------
    def Open(self, comport, baudrate):
        if DEBUG_UART:
            print('{}: Open: begin'.format(self.ID))
        self.Comport = comport
        self.Baudrate = baudrate
        self.TxLines.clear()
        self.Thread.Start()
        if DEBUG_UART:
            print('{}: Open: end'.format(self.ID))
        return True
    def Close(self):        
        if DEBUG_UART:
            print('{}: Close: begin'.format(self.ID))
        self.Thread.Abort()
        self.TxLines.clear()
        if DEBUG_UART:
            print('{}: Close: end'.format(self.ID))
        return True
    #
    def TxLine(self, txline):
        self.TxLines.append(txline)
        return True
    def TxCommand(self, command):
        self.TxLines.append(command)
        return True
    def TxResponse(self, response):
        self.TxLines.append(response)
        return True
    def TxEvent(self, event):
        self.TxLines.append(event)
        return True
#
