#
import time as TIM
import serial as SER
import serial.tools.list_ports
#
#--------------------------------------------------
#   Helper
#--------------------------------------------------
def ListComPorts():
    PortEntries = serial.tools.list_ports.comports()
    print('List of ComPorts:')
    for ComPort, ComDescription, ComID in sorted(PortEntries):
        print('{} : {} - [{}]'.format(ComPort, ComDescription, ComID))
    return
#
def GetComPortsExistent():
    PortEntries = serial.tools.list_ports.comports()
    ComPorts = []
    ComDescriptions = []
    ComIDs = []
    for ComPort, ComDescription, ComID in sorted(PortEntries):
        ComPorts.append(ComPort)
        ComDescriptions.append(ComDescription)
        ComIDs.append(ComID)
    return [ComPorts, ComDescriptions, ComIDs]
#
def GetComPortsAvailable():
    PortEntries = serial.tools.list_ports.comports()
    ComPorts = []
    ComDescriptions = []
    ComIDs = []
    for ComPort, ComDescription, ComID in sorted(PortEntries):
        try:
            S = SER.Serial(ComPort)
            S.close()
            if (-1 == ComDescription.find('tooth')):
                ComPorts.append(ComPort)
                ComDescriptions.append(ComDescription)
                ComIDs.append(ComID)
        except:
            pass        
    return [ComPorts, ComDescriptions, ComIDs]