#
#COMPORT_COMMANDER   = 'COM32'
#COMPORT_CONTROLLER  = 'COM33'
#COMPORT_HARDWARE    = 'COM34'
#COMPORT_SCRIPTOR    = 'COM55'
#COMPORT_REMOTER      = 'COM55'
COMPORT_REMOTER      = 'COM50'
#
BAUDRATE_DISPATCHER = '115200'
#
#DEBUG_DISPATCHERCOMMANDER   = False
#DEBUG_DISPATCHERCONTROLLER  = False
#DEBUG_DISPATCHERHARDWARE    = False
DEBUG_DISPATCHERSCRIPTOR    = False
DEBUG_LEDSYSTEM             = False
#
SYMBOL_ALL          = 'A'
SYMBOL_COMMANDER    = 'P'
SYMBOL_CONTROLLER   = 'C'
SYMBOL_HARDWARE     = 'H'
SYMBOL_SCRIPTOR     = 'S'
SYMBOL_ESP32        = 'E'
SYMBOL_STM32        = 'T' 
SYMBOL_REMOTER      = 'R'
#
TOKEN_COMMAND       = '@'
TOKEN_RESPONSE      = '$'
TOKEN_EVENT         = '!'
#TOKEN_COMMENT       = '#'
#TOKEN_WARNING       = '.'
#TOKEN_ERROR         = ':'
#
TEXT_COMMANDER  = '[P]-Commander'
TEXT_CONTROLLER = '[C]-Controller'
TEXT_HARDWARE   = '[H]-Hardware'
TEXT_SCRIPTOR   = '[S]-Scriptor'
TEXT_ESP32      = '[E]-Esp32'
TEXT_REMOTER    = '[R]-Remoter'
#
MASK_LEDSYSTEM_STATE        = 'SLS {}'
#
COMMAND_LEDSYSTEM_SETON     = 'LSO'
COMMAND_LEDSYSTEM_SETOFF    = 'LSF'
#
COMMAND_MOTORLEFT_MOVEPOSITIVE   = 'MLP'
COMMAND_MOTORLEFT_MOVENEGATIVE   = 'MLN'
COMMAND_MOTORLEFT_FREERUN        = 'MLF'
COMMAND_MOTORLEFT_FORCEHALT      = 'MLH'
#
COMMAND_MOTORRIGHT_MOVEPOSITIVE  = 'MRP'
COMMAND_MOTORRIGHT_MOVENEGATIVE  = 'MRN'
COMMAND_MOTORRIGHT_FREERUN       = 'MRF'
COMMAND_MOTORRIGHT_FORCEHALT     = 'MRH'
#
#
import time as TIM
#
def Error(message, delay):
    print('Error: {}!'.format(message))
    TIM.sleep(delay)
    #
def BuildTxLine(header, source, target, command, parameters=''):
    if (0 < len(parameters)):
        TXL = '{}{}{} {} {}'.format(header, source, target, command, parameters)
    else:
        TXL = '{}{}{} {}'.format(header, source, target, command)
    return TXL
#
def ConvertSourceTargetCharacter(text):
    if (TEXT_COMMANDER == text):
        return 'P'
    if (TEXT_CONTROLLER == text):
        return 'C'
    if (TEXT_HARDWARE == text):
        return 'H'
    if (TEXT_SCRIPTOR == text):
        return 'S'
    if (TEXT_ESP32 == text):
        return 'E'
    if (TEXT_REMOTER == text):
        return 'R'
    return '?'
#
def ResultAppend(result):
    if (True == result):
        return ' 1' 
    return ' 0'
def ParameterResult(parameter):
    if ('1' == parameter[0]):
        return True
    return False
def ParameterExtract(parameter):
    return parameter[2:]
def ParameterAppend(parameter):
    return ' ' + parameter
#
def LinesText(lines):
    Text = ''
    for Line in lines:
        Text += Line + '\r\n'
    return Text
def TextLines(text):
    Lines = []
    Line = ''
    for C in text:
        if ('\r' == C) or ('\n' == C):
            if (0 < len(Line)):
                Lines.append(Line)
                Line = ''
        else:
            Line += C
    return Lines
#
#---------------------------------------------------------    
#   Helper - System
#---------------------------------------------------------
def Error(message):
    print('Error: {} !'.format(message))
def Warning(message):
    print('Warning: {} !'.format(message))
def Debug(message):
    print('Debug: {}'.format(message))
def Message(message):
    print('>{}'.format(message))
def Info(message):
    print(message)
#
