#
import sys
import time as TIM
import runpy
import serial as SER
#
import Define as DEF
import Thread as THR
import Lines as LIN
import Uart as UAR
#
#--------------------------------------------------
#   Dispatcher
#--------------------------------------------------
class CDispatcher():
    #---------------------------------------------------------    
    #   Constructor
    #---------------------------------------------------------
    def __init__(self,
                 uart_pushtxline,
                 ledsystem_seton, ledsystem_setoff,
                 motorl_movepositive, motorl_movenegative, 
                 motorl_freerun, motorl_forcehalt,
                 motorr_movepositive, motorr_movenegative, 
                 motorr_freerun, motorr_forcehalt,
                 servoa_setposition, servoa_setlow,
                 servoa_setmedium, servoa_sethigh,
                 servob_setposition, servob_setlow,
                 servob_setmedium, servob_sethigh):
        self.UartPushTxLine = uart_pushtxline
        self.LedSystem_SetOn = ledsystem_seton
        self.LedSystem_SetOff = ledsystem_setoff
        self.MotorL_MovePositive = motorl_movepositive
        self.MotorL_MoveNegative = motorl_movenegative
        self.MotorL_FreeRun = motorl_freerun
        self.MotorL_ForceHalt = motorl_forcehalt
        self.MotorR_MovePositive = motorr_movepositive
        self.MotorR_MoveNegative = motorr_movenegative
        self.MotorR_FreeRun = motorr_freerun
        self.MotorR_ForceHalt = motorr_forcehalt
        self.ServoA_SetPosition = servoa_setposition
        self.ServoA_SetLow = servoa_setlow
        self.ServoA_SetMedium = servoa_setmedium
        self.ServoA_SetHigh = servoa_sethigh
        self.ServoB_SetPosition = servob_setposition 
        self.ServoB_SetLow = servob_setlow
        self.ServoB_SetMedium = servob_setmedium
        self.ServoB_SetHigh = servob_sethigh
        #
        self.EventAnalysed = ''
        self.RxLines = LIN.CLines()
        self.TxLines = LIN.CLines()
        self.Commands = LIN.CLines()
        self.CommandResponse = ''
        self.Thread = THR.CThread('THR', 
                                  self.OnStart, self.OnBusy, 
                                  self.OnAbort, self.OnEnd)
        self.CounterResponse = 0
        #
        self.RxParameter = ''
        
        return
    #---------------------------------------------------------    
    #   Property
    #---------------------------------------------------------
    def GetRxResult(self):
        return self.RxResult
    def GetRxParameter(self):
        return self.RxParameter
        #    
    #---------------------------------------------------------    
    #   Callback - Thread
    #---------------------------------------------------------
    def OnStart(self, thread):
        # debug 
        DEF.Message('{}: Thread_OnStart: begin'.format(thread.ID))
        self.RxLines.clear()
        self.TxLines.clear()
        self.Commands.clear()
        self.ResetCommandPushedResponse()
        return
    #
    def OnBusy(self, thread):
        #debug DEF.Message('{}: Thread_OnBusy:'.format(thread.ID))
        # RxLines
        if (0 < self.RxLines.Count()):
            RXL = self.RxLines.Pop()            
            self.AnalyseRxLine(RXL)
        # TxLines
        if (0 < self.TxLines.Count()):
            TXL = self.TxLines.Pop()
            self.UartPushTxLine(TXL)
        # Commands
        if (0 < self.Commands.Count()):
            if not(self.IsWaitingForCommandResponse()):                
                Command = self.Commands.Pop()
                if (7 <= len(Command)):
                    H = Command[0]
                    S = Command[1]
                    T = Command[2]
                    C = Command[4:7]
                    P = Command[8:]
                    print('++++++++++++++++++++++++++++++++++++++++++++++')
                    self.SetCommandResponseActive(Command)
                    self.UartPushTxLine(Command)
        #
        TIM.sleep(0.001) 
        #debug TIM.sleep(0.501) 
        return (thread.Loop)
    #
    def OnAbort(self, thread):
        # debug
        DEF.Message('{}: Thread_OnAbort: begin'.format(thread.ID))
        self.RxLines.clear()
        self.TxLines.clear()
        self.Commands.clear()
        self.ResetCommandPushedResponse()
        return
    #
    def OnEnd(self, thread):
        # debug 
        DEF.Message('{}: Thread_OnEnd: begin'.format(thread.ID))
        self.RxLines.clear()
        self.TxLines.clear()
        self.Commands.clear()
        self.ResetCommandPushedResponse()
        return
    #
    #---------------------------------------------------------    
    #   Helper
    #---------------------------------------------------------
    def ResetCommandPushedResponse(self):
        #debug DEF.Message('Dispatcher.ResetCommandPushedResponse')
        self.CounterResponse = 0        
        self.CommandResponse = ''
        #self.CommandPushed = False
        return
    def SetCommandResponseActive(self, command):
        #debug DEF.Message('Dispatcher.SetCommandResponseActive[{}]'.format(command))
        self.CommandResponse = command
        return
    def IsWaitingForCommandResponse(self):
        Result = (0 < len(self.CommandResponse))
        #debug DEF.Message('Dispatcher.IsWaitingForCommandResponse[{}]'.format(Result))
        return Result
    #
    #---------------------------------------------------------------------------------
    def PushRxLine(self, rxline):
        self.RxLines.Push(rxline)
        #debug DEF.Message('Dispatcher.PushRxLine<{}>[{}]'.format(len(self.RxLines), rxline))        
        return
    def PushTxLine(self, txline):
        self.TxLines.Push(txline)
        #debug DEF.Message('Dispatcher.PushTxLine<{}>[{}]'.format(len(self.TxLines), txline))
        return
    def PushCommand(self, commandline):
        self.Commands.Push(commandline)
        self.CommandPushed = True
        self.CommandResponse = ''
        #debug DEF.Message('Dispatcher.PushCommand<{}>[{}]'.format(len(self.Commands), commandline))
        return
    #    
    #
    #
    #---------------------------------------------------------    
    #   Handler
    #---------------------------------------------------------
    def Open(self):
        #debug DEF.Message('OPEN')
        self.Thread.Start()
        return True
    def Close(self):        
        #debug DEF.Message('CLOSE')
        self.Thread.Abort()
        return True
    #
    
    
    
    
    
    #---------------------------------------------------------    
    #   Helper - Command Source -> This(P)
    #---------------------------------------------------------   
    def AnalyseCommand(self, source, target, command, parameters):
        # debug DEF.Message('AnalyseCommand[{}|{}]<{}><{}>'.format(source, target, command, parameters))
        # if (DEF.SYMBOL_COMMANDER == target): # P
        #     # RXL = DEF.BuildTxLine(DEF.TOKEN_RESPONSE, source, target, command, parameters)
        #     # if (DEF.COMMAND_LEDSYSTEM_SETON == command):
        #     #     if (None != self.LedSystem_SetOn):
        #     #         self.LedSystem_SetOn()
        #     #         self.AnalyseRxLine(RXL)
        #     #         return True             
        #     return False                    
    #         # if (DEF.COMMAND_LEDSYSTEM_SETOFF == command):
    #         #     if (None != self.LedSystem_SetOff):
    #         #         self.LedSystem_SetOff()
    #         #         self.AnalyseRxLine(RXL)
    #         #         return True             
    #         #     return False                    
    #         # if (DEF.COMMAND_MOTOR_MOVEFORWARD == command):
    #         #     if (None != self.Motor_MoveForward):
    #         #         self.Motor_MoveForward()
    #         #         self.AnalyseRxLine(RXL)
    #         #         return True             
    #         #     return False                    
    #         # if (DEF.COMMAND_MOTOR_MOVEBACKWARD == command):
    #         #     if (None != self.Motor_MoveBackward):
    #         #         self.Motor_MoveBackward()
    #         #         self.AnalyseRxLine(RXL)
    #         #         return True             
    #         #     return False                    
    #         # if (DEF.COMMAND_MOTOR_ABORTMOTION == command):
    #         #     if (None != self.Motor_AbortMotion):
    #         #         self.Motor_AbortMotion()
    #         #         self.AnalyseRxLine(RXL)
    #         #         return True             
    #         #     return False                    
    #         return False
    #     else: # forward to target:
    #         TXL = DEF.BuildTxLine(DEF.TOKEN_COMMAND, source, target, command, parameters)
    #         #debug DEF.Message('Forwarding[{}]'.format(TXL))
    #         self.TxLines.Push(TXL)
    #     return True
        return False
    #
    def AnalyseResponse(self, source, target, command, parameter):
        #debug print('***AnalyseResponse S[{}]T[{}]<{}><{}>'.format(source, target, command, parameter))
        RxResult = False
        if (DEF.SYMBOL_COMMANDER == source): # == C
            #debug print('RMT: >>>CommandResponse[{}]-[{}]'.format(self.CommandResponse, tokens))
            #debug print('RMT: >>>CommandResponse[{}] completed'.format(self.CommandResponse))
            if (DEF.SYMBOL_STM32 == target): # == T
                if (DEF.COMMAND_LEDSYSTEM_SETON == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_LEDSYSTEM_SETOFF == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORLEFT_MOVEPOSITIVE == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORLEFT_MOVENEGATIVE == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORLEFT_FREERUN == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORLEFT_FORCEHALT == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORRIGHT_MOVEPOSITIVE == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORRIGHT_MOVENEGATIVE == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORRIGHT_FREERUN == command):
                    RxResult = DEF.ParameterResult(parameter)
                elif (DEF.COMMAND_MOTORRIGHT_FORCEHALT == command):
                    RxResult = DEF.ParameterResult(parameter)
            self.ResetCommandPushedResponse() # HS completed -> send of new commands possible
            print('----------------------------------------------')
        else:
            # != C -> forward to P, H, S!!!
            TXL = DEF.BuildTxLine(DEF.TOKEN_RESPONSE, source, target, command, parameter)
            self.TxLines.Push(TXL)        
            #debug print('RMT: AnalyseResponse: Forward [{}]'.format(TXL))
        if not(RxResult):
            DEF.Error('Invalid Response')
        return RxResult
    #
    # def AnalyseEvent(self, source, target, command, parameters):
    #     #debug print('AnalyseEvent: S[{}]T[{}]T[{}]'.format(source, target, command, parameters))
    #     TXL = DEF.BuildTxLine(DEF.TOKEN_EVENT, source, target, command, parameters)
    #     if (DEF.SYMBOL_REMOTER == source):
    #         #debug print('AnalyseEvent:EventAround(ThisDevice)[{}]'.format(TXL))
    #         pass
    #     elif (DEF.SYMBOL_REMOTER == target):
    #         #debug print('AnalyseEvent:EventReachedTarget[{}]'.format(TXL))
    #         pass
    #     else: # transmit to other devices
    #         #debug print('AnalyseEvent: Forward [{}]'.format(TXL))
    #         self.PushTxLine(TXL)
    #     return True
    #
    def AnalyseRxLine(self, rxline):
        # <@><s><t>< ><cmd>[< ><pi>|k]
        if (7 <= len(rxline)):
            H = rxline[0]
            S = rxline[1]
            T = rxline[2]
            C = rxline[4:7]
            P = rxline[8:]
            # debug DEF.Message('***AnalyseRxLine: H[{}] S[{}] T[{}] C[{}] P[{}]'.format(H, S, T, C, P))
            if (DEF.TOKEN_COMMAND == H):
                return self.AnalyseCommand(S, T, C, P)
            if (DEF.TOKEN_RESPONSE == H):
                return self.AnalyseResponse(S, T, C, P)
            # if (DEF.TOKEN_EVENT == H):
            #     return self.AnalyseEvent(S, T, C, P)
        return False
    #
    # def AnalyseTxLine(self, txline):
    #     # <@><s><t>< ><cmd>[< ><pi>|k]
    #     if 
    #     if (7 <= len(txline)):
    #         H = txline[0]
    #         # S = txline[1]
    #         # T = txline[2]
    #         # C = txline[4:7]
    #         # P = txline[8:]
    #         if (DEF.TOKEN_COMMAND == H):
    #             self.Commands.Push(txline)
    #             return True
    #         if (DEF.TOKEN_RESPONSE == H):
    #             self.Commands.Push(txline)
    #             return True
    #         if (DEF.TOKEN_EVENT == H):
    #             self.Commands.Push(txline)
    #             return True
    #     return False
    
#  ???   def AnalyseTxLine(self, txline):
#         if (None == self.OnTxLine):
#             return False
#         self.OnTxLine(txline)
#         return True
# #    
    
    
#