#include "Define.h"
//
#include "Define.h"
#include "CUart.h"
#include "Dispatcher.h"
#include "Servo.h"
#include "Motor.h"
//
extern CUart UartCRB;         
extern CDispatcher Dispatcher;
extern CLed LedSystem;
extern CMotor MotorL;
extern CMotor MotorR;
extern CServo ServoA;
extern CServo ServoB;
//
//------------------------------------------------------------
//
//------------------------------------------------------------
void UartCRB_OnRxLine(String rxline)
{  // Message(Format("UartCRB_OnRxLine[%s]", rxline.c_str()));
  Message(rxline.c_str());
  Dispatcher.PushRxLine(rxline);
}
String UartCRB_OnTxLine(String txline)
{  // Message(Format("UartCRB_OnTxLine[%s]", txline.c_str()));
  Message(txline.c_str());
  return txline;
}
//------------------------------------------------------------
//  LedSystem - Event
//------------------------------------------------------------
void LedSystem_OnStateChanged(EStateLed state)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SLS %d", (Int32)state));
}
//------------------------------------------------------------
//  LedSystem - Command
//------------------------------------------------------------
void LedSystem_OnSetOn(void)
{ // Message("LedSystem_OnSetOn");
  LedSystem.SetOn();
}
void LedSystem_OnSetOff(void)
{  // Message("LedSystem_OnSetOff");
  LedSystem.SetOff();
}
//------------------------------------------------------------
//  Motor - Left - Event
//------------------------------------------------------------
void MotorL_OnStateChanged(EStateMotor state)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SML %d", (Int32)state));
}
void MotorL_OnVelocityChanged(TPercent velocity)
{
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SML %s", (Float32)velocity));
}
//------------------------------------------------------------
//  Motor - Left - Command
//------------------------------------------------------------
void MotorL_OnMovePositive(TPercent pwm)
{
  MotorL.MovePositive(pwm);
}
void MotorL_OnMoveNegative(TPercent pwm)
{
  MotorL.MoveNegative(pwm);
}
void MotorL_OnFreeRun()
{
  MotorL.FreeRun();
}
void MotorL_OnForceHalt()
{
  MotorL.ForceHalt();
}
//------------------------------------------------------------
//  Motor - Right - Event
//------------------------------------------------------------
void MotorR_OnStateChanged(EStateMotor state)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SMR %d", (Int32)state));
}
void MotorR_OnVelocityChanged(TPercent velocity)
{
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SMR %s", (Float32)velocity));
}
//------------------------------------------------------------
//  Motor - Right - Command
//------------------------------------------------------------
void MotorR_OnMovePositive(TPercent pwm)
{
  MotorR.MovePositive(pwm);
}
void MotorR_OnMoveNegative(TPercent pwm)
{
  MotorR.MoveNegative(pwm);
}
void MotorR_OnFreeRun()
{
  MotorR.FreeRun();
}
void MotorR_OnForceHalt()
{
  MotorR.ForceHalt();
}
//------------------------------------------------------------
//  ServoA - Left - Event
//------------------------------------------------------------
void ServoA_OnStateChanged(EStateServo state)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SSA %d", (Int32)state));
}
void ServoA_OnPositionChanged(TPercent position)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("PSA %s", (Float32)position));
}
//------------------------------------------------------------
//  ServoA - Left - Command
//------------------------------------------------------------
void ServoA_OnSetPosition(TPercent pwm)
{
  ServoA.SetPosition(pwm);
}
void ServoA_OnSetLow(void)
{
  ServoA.SetLow();
}
void ServoA_OnSetMiddle(void)
{
  ServoA.SetMiddle();
}
void ServoA_OnSetHigh(void)
{
  ServoA.SetHigh();
}
//------------------------------------------------------------
//  ServoB - Right - Event
//------------------------------------------------------------
void ServoB_OnStateChanged(EStateServo state)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("SSB %d", (Int32)state));
}
void ServoB_OnPositionChanged(TPercent position)
{  
  Dispatcher.PushTxEvent(SYMBOL_STM32, SYMBOL_ALL, Format("PSB %s", (Float32)position));
}
//------------------------------------------------------------
//  ServoB - Right - Command
//------------------------------------------------------------
void ServoB_OnSetPosition(TPercent pwm)
{
    ServoB.SetPosition(pwm);
}
void ServoB_OnSetLow(void)
{
    ServoB.SetLow();
}
void ServoB_OnSetMiddle(void)
{
  ServoB.SetMiddle();
}
void ServoB_OnSetHigh(void)
{
  ServoB.SetHigh();
}
//
//--------------------------------------------------------------
//
//--------------------------------------------------------------

CUart UartCRB(NULL, PIN_UARTCRB_RX, PIN_UARTCRB_TX, 
              BAUDRATE_UARTPC, UartCRB_OnRxLine, UartCRB_OnTxLine); 
CDispatcher Dispatcher(UartCRB_OnTxLine,
                       LedSystem_OnSetOn, LedSystem_OnSetOff,
                       MotorL_OnMovePositive, MotorL_OnMoveNegative,
                       MotorL_OnFreeRun, MotorL_OnForceHalt,
                       MotorR_OnMovePositive, MotorR_OnMoveNegative,
                       MotorR_OnFreeRun, MotorR_OnForceHalt,
                       ServoA_OnSetPosition, ServoA_OnSetLow,
                       ServoA_OnSetMiddle, ServoA_OnSetHigh,
                       ServoB_OnSetPosition, ServoB_OnSetLow,
                       ServoB_OnSetMiddle, ServoB_OnSetHigh);
CLed LedSystem(PIN_LEDSYSTEM, true, LedSystem_OnStateChanged);
CServo ServoA(PIN_SERVOA_SIGNAL, PWM_MINIMUM_SAS, PWM_MAXIMUM_SAS,
              ServoA_OnStateChanged, ServoA_OnPositionChanged);
CServo ServoB(PIN_SERVOB_SIGNAL, PWM_MINIMUM_SBS, PWM_MAXIMUM_SBS,
              ServoB_OnStateChanged, ServoB_OnPositionChanged);
CMotor MotorL(PIN_PWM_PB1, PIN_PWM_PB0,
              MotorL_OnStateChanged, MotorL_OnVelocityChanged);
CMotor MotorR(PIN_PWM_PA7, PIN_PWM_PA6,
              MotorR_OnStateChanged, MotorR_OnVelocityChanged);
//
void setup()
{ 
    UartCRB.Open();
    Dispatcher.Open();
    delay(2200);
    Message("\r\n*** Stm32F103CrbServoMotor");
    Message("Version...: 00V09");
    Message("Date......: 220419");
    Message("Time......: 1724");
    Message("Author....: OMdevelop");
    //
    LedSystem.Open();
}
//
void loop()
{
  UartCRB.Execute();
  Dispatcher.Execute();
}
//