//
#include "Motor.h"
//
CMotor::CMotor(TPin pindirectiona, TPin pindirectionb,
               TCB_Motor_OnStateChanged onstatechanged,
               TCB_Motor_OnVelocityChanged onvelocitychanged)
{
    FPPwmA = new CPulseWidthModulator(pindirectiona);
    FPPwmB = new CPulseWidthModulator(pindirectionb);
    FPPwmA->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
    FPPwmB->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
    FOnStateChanged = onstatechanged;
    FOnVelocityChanged = onvelocitychanged;
    FState = smUndefined;
}
//
void CMotor::SetState(EStateMotor state)
{
    if (state != FState)
    {
        FState = state;
        switch (FState)
        {
            case smIdle:
                FreeRun();
                break;
            case smPositive:
                break;
            case smNegative:
                break;
            default: // smUndefined:
                FreeRun();
                break;
        }
        if (NULL != FOnStateChanged)
        {
            FOnStateChanged(FState);
        }
    }
}
//
Boolean CMotor::Open(void)
{
    FPPwmA->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
    FPPwmB->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
    SetState(smIdle);
    return true;
}
//
Boolean CMotor::Close(void)
{
    FPPwmA->SetFrequencyPwm(FREQUENCY_ZERO, PERCENT_MINIMUM);
    FPPwmB->SetFrequencyPwm(FREQUENCY_ZERO, PERCENT_MINIMUM);
    SetState(smUndefined);
    return true;
}

void CMotor::MovePositive(TPercent pwm)
{
  FPPwmA->SetFrequencyPwm(FREQUENCY_MOTOR, (int)(0.5 + pwm));
  FPPwmB->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
}
void CMotor::MoveNegative(TPercent pwm)
{
  FPPwmA->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
  FPPwmB->SetFrequencyPwm(FREQUENCY_MOTOR, (int)(0.5 + pwm));
}
void CMotor::ForceHalt(void)
{
  FPPwmA->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MAXIMUM);
  FPPwmB->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MAXIMUM);
}
void CMotor::FreeRun(void)
{
  FPPwmA->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
  FPPwmB->SetFrequencyPwm(FREQUENCY_MOTOR, PERCENT_MINIMUM);
}
//