#
import threading as THR
#
DEBUG_THREAD = False
#
class CThread():
    #
    def __init__(self, id, onstart, onbusy, onabort, onend):
        self.ID = id
        self.OnStart = onstart
        self.OnBusy = onbusy
        self.OnAbort = onabort
        self.OnEnd = onend
        self.Thread = None
        self.Loop = False
        return
    #
    def Thread_OnExecute(self):
        if DEBUG_THREAD:
            print('{}-Thread: OnExecute: begin'.format(self.ID))
        self.Loop = True
        if (None != self.OnStart):
            self.OnStart(self)
        if (None != self.OnBusy):
            while (self.Loop):
                self.Loop = self.OnBusy(self)
        if (None != self.OnEnd):
            self.OnEnd(self)        
        if DEBUG_THREAD:
            print('{}-Thread: OnExecute: end'.format(self.ID))
        return
    #
    def IsBusy(self):        
        return self.Loop
    #
    def Start(self):
        if DEBUG_THREAD:
            print('{}-Thread: Start: begin'.format(self.ID))
        self.Abort()
        self.Thread = THR.Thread(target=self.Thread_OnExecute)
        self.Thread.start()
        if DEBUG_THREAD:
            print('{}-Thread: Start: end'.format(self.ID))
        return
    def Abort(self):
        if DEBUG_THREAD:
            print('{}-Thread: Abort: begin'.format(self.ID))
        self.Loop = False
        if (None != self.Thread):
            if (None != self.OnAbort):
                self.OnAbort(self)
            self.Thread.join()
        self.Thread = None
        if DEBUG_THREAD:
            print('{}-Thread: Abort: end'.format(self.ID))
        return