#
import Thread as THR
import CPCDevice as CPCD
#
STATE_MOTOR_ERROR         = 0
STATE_MOTOR_WARNING       = 1
STATE_MOTOR_IDLE          = 2
STATE_MOTOR_MOVEFORWARD   = 3
STATE_MOTOR_MOVEBACKWARD  = 4
STATE_MOTOR_ABORTMOTION   = 5
EStateMotor = ['Error', 'Warning', 'Idle', 'MoveForward', 'MoveBackward', 'AbortMotion']
#
class CMotor(CPCD.CDevice):
    #
    def __init__(self, onstatechanged, onvelocitychanged): 
        super().__init__()
        self.OnStateChanged = onstatechanged
        self.OnVelocityChanged = onvelocitychanged
        self.State = STATE_MOTOR_IDLE
        self.Thread = None
        
        # ledsystem_onstatechanged,               
        # #self.lblLedSystem.setText('-')
        # self.LedSystem_OnStateChanged = ledsystem_onstatechanged
        # self.Motor_OnStateChanged = motor_onstatechanged
        
        
        return
    #
    def GetStateText(self):
        if (STATE_MOTOR_WARNING == self.State):
            return EStateMotor[STATE_MOTOR_WARNING]
        if (STATE_MOTOR_IDLE == self.State):
            return EStateMotor[STATE_MOTOR_IDLE]
        if (STATE_MOTOR_MOVEFORWARD == self.State):
            return EStateMotor[STATE_MOTOR_MOVEFORWARD]
        if (STATE_MOTOR_MOVEBACKWARD == self.State):
            return EStateMotor[STATE_MOTOR_MOVEBACKWARD]
        if (STATE_MOTOR_ABORTMOTION == self.State):
            return EStateMotor[STATE_MOTOR_ABORTMOTION]
        self.State = STATE_MOTOR_ERROR
        return EStateMotor[STATE_MOTOR_ERROR]            
    #
    def SetState(self, state): #int
        if (state != self.State):
            self.State = state
            if (None != self.OnStateChanged):
                self.OnStateChanged(self.State)
    #
    def MoveForward(self):
        #debug if (STATE_MOTOR_IDLE == self.State):
        self.SetState(STATE_MOTOR_MOVEFORWARD)
        return True
        #debug return False
    #
    def MoveBackward(self):
        #debug if (STATE_MOTOR_IDLE == self.State):
        self.SetState(STATE_MOTOR_MOVEBACKWARD)
        return True
        #debug return False
    #    
    def AbortMotion(self):
        #debug if (self.State in [STATE_MOTOR_MOVEFORWARD, STATE_MOTOR_MOVEBACKWARD]):
        self.SetState(STATE_MOTOR_ABORTMOTION)
        return True
        #debug return False
    #
#