#
import sys
import time
# ok import re
from PyQt6 import QtCore, QtGui, QtWidgets, uic
from PyQt6.QtCore import QTimer
import serial as SER
import UartHelper as UAH
#
import Define as DEF
import Thread as THR
import Uart as UAR
#
DEBUG_WINDOWMAIN = False
#
#--------------------------------------------------
#   WNDScriptor
#--------------------------------------------------
class CWNDRemoter(QtWidgets.QMainWindow):
    #---------------------------------------------------------
    #   Constructor
    #---------------------------------------------------------
    def __init__(self,
                 onuartcrbopen, onuartcrbclose,                 
                 onledsystemseton, onledsystemsetoff,
                 onmotorlmoveforward, onmotorlmovebackward, 
                 onmotorlfreerun, onmotorlforcehalt,
                 onmotorrmoveforward, onmotorrmovebackward, 
                 onmotorrfreerun, onmotorrforcehalt,
                 onservoasetposition, onservoasetlow,
                 onservoasetmedium, onservoasethigh,
                 onservobsetposition, onservobsetlow,
                 onservobsetmedium, onservobsethigh):
        super().__init__()
        self.uic = uic.loadUi('WNDRemoter.ui', self)
        #
        self.UartCRBOpen = onuartcrbopen
        self.UartCRBClose = onuartcrbclose        
        self.RefreshComPortsAvailable()     
        # self.cbxBaudrateCRB.addItems(['9600', '19200', '115200', '230400', '250000'])
        self.cbxBaudrateCRB.addItems(['115200'])
        self.btnOpenUartCRB.clicked.connect(self.btnOpenUartCRB_OnClick)
        self.btnCloseUartCRB.clicked.connect(self.btnCloseUartCRB_OnClick)
        self.btnOpenUartCRB.setEnabled(True)
        self.btnCloseUartCRB.setEnabled(False)
        #
        self.btnLedSystemSetOn.clicked.connect(onledsystemseton)
        self.btnLedSystemSetOff.clicked.connect(onledsystemsetoff)
        #
        self.btnMotorLMoveForward.clicked.connect(onmotorlmoveforward)
        self.btnMotorLMoveBackward.clicked.connect(onmotorlmovebackward)
        self.btnMotorLFreeRun.clicked.connect(onmotorlfreerun)
        self.btnMotorLForceHalt.clicked.connect(onmotorlforcehalt)
        #
        self.btnMotorRMoveForward.clicked.connect(onmotorrmoveforward)
        self.btnMotorRMoveBackward.clicked.connect(onmotorrmovebackward)
        self.btnMotorRFreeRun.clicked.connect(onmotorrfreerun)
        self.btnMotorRForceHalt.clicked.connect(onmotorrforcehalt)
        #
        self.btnServoASetPosition.clicked.connect(onservoasetposition)
        self.btnServoASetLow.clicked.connect(onservoasetlow)
        self.btnServoASetMedium.clicked.connect(onservoasetmedium)
        self.btnServoASetHigh.clicked.connect(onservoasethigh)
        #
        self.btnServoBSetPosition.clicked.connect(onservobsetposition)
        self.btnServoBSetLow.clicked.connect(onservobsetlow)
        self.btnServoBSetMedium.clicked.connect(onservobsetmedium)
        self.btnServoBSetHigh.clicked.connect(onservobsethigh)
        #
        return
    #
    def ProtocolRxLine(self, header, rxline):
        self.lbxProtocol.addItem('{}-RxD> {}'.format(header, rxline.rstrip()))
        return
    def ProtocolTxLine(self, header, txline):
        self.lbxProtocol.addItem('{}-TxD> {}'.format(header, txline.rstrip()))
        return 
    def ProtocolTransmit(self, header, txline):
        self.lbxProtocol.addItem('{}-TxD> {}'.format(header, txline.rstrip()))
        return
    def ProtocolReceive(self, header, rxline):
        self.lbxProtocol.addItem('{}-RxD> {}'.format(header, rxline))
        return 
    #
    def Open(self):
        return
    def Close(self):        
        return
    #
    def GetTextScript(self):
        Text = self.tbxScript.toPlainText()
        return Text
    def SetTextScript(self, text):
        self.tbxScript.setText(text)
        return
    def GetLinesScript(self):
        Text = self.tbxScript.toPlainText()        
        # ok Lines = re.split('\n', Text)
        Lines = Text.split('\n')
        return Lines
    #
    def GetFileName(self):
        return self.ledFileName.text()
    #
    def SetMotorStateText(self, motorstatetext):
        self.lblMotorState.setText(motorstatetext)
    #
    def GetMotorLVelocity(self):
        return self.sbxMotorLVelocity.text()
    def GetMotorRVelocity(self):
        return self.sbxMotorRVelocity.text()
    #
    def GetServoAPosition(self):
        return self.sbxServoAPosition.text()
    def SetServoAPosition(self, position):
        PN = float(position)
        PP = float(self.sbxServoAPosition.text())
        if (PN != PP):
            #debug print('SetServoAPosition:')
            self.sbxServoAPosition.setValue(PN)
            #debug print('SetServoAPosition.')
        return
    #
    def GetServoBPosition(self):
        return self.sbxServoBPosition.text()
    def SetServoBPosition(self, position):
        PN = float(position)
        PP = float(self.sbxServoBPosition.text())
        if (PN != PP):
            #debug print('SetServoBPosition:')
            self.sbxServoBPosition.setValue(PN)
            #debug print('SetServoBPosition.')
        return
    #
    def SetServoAState(self, state):
        self.lblServoAState.setText(state)
    #
    def SetServoBState(self, state):
        self.lblServoBState.setText(state)
    #
    #---------------------------------------------------------
    #   Helper
    #---------------------------------------------------------
    def RefreshComPortsAvailable(self):
        CPA = UAH.GetComPortsAvailable()
        if (self.cbxComPortCRB.isEnabled()):
            self.cbxComPortCRB.clear()
            self.cbxComPortCRB.addItems(CPA[0])
            self.cbxComPortCRB.setCurrentIndex(0)
        return     
    #
    #---------------------------------------------------------
    #   Helper - MainWindow
    #---------------------------------------------------------
    def PositionSize(self, left, top, width, height):
        if (0 != left) and (0 != top):
            self.move(left, top)
        if (0 != width) and (0 != height):
            self.resize(width, height)
        return
    #---------------------------------------------------------
    #   Event - MainWindow
    #--------------------------------------------------------- 
    # def btnSaveProtocol_OnClick(self):
    #     # try:
    #     #     File = open('Protocol.txt', 'w')
    #     #     for IL in range(0, self.lbxProtocol.count()):                        
    #     #         File.write(self.lbxProtocol.item(IL).text() + '\n')
    #     # except:
    #     #     print('Error: Cannot write to Protocol-File!')
    #     #     pass
    #     # finally:
    #     #     pass #File.close()
    #     # if (None != self.OnExecute):
    #     #     self.OnExecute('./script/count.py')
    #     return
    # def btnClearProtocol_OnClick(self):
    #     #self.lbxProtocol.clear()       
    #     # if (None != self.OnExecute):
    #     #     self.OnExecute('./script/blink.py')
    #     return
    def btnTransmitCommand_OnClick(self):
        # print('btnTransmitCommand_OnClick: begin')
        S = DEF.ConvertSourceTargetCharacter(self.cbxSource.currentText())
        T = DEF.ConvertSourceTargetCharacter(self.cbxTarget.currentText())
        C = self.cbxCommand.currentText()
        TXC = DEF.BuildTxLine(DEF.TOKEN_COMMAND, S, T, C)
        # print('TransmitCommand[{}]'.format(TXC.rstrip()))
        self.Dispatcher.Push(TXC)
        # print('btnTransmitCommand_OnClick: end')
        return    
    #---------------------------------------------------------
    #   Helper - UartCRB
    #---------------------------------------------------------
    def OpenUartCRB(self, comport, baudrate):
        if self.UartCRBOpen(comport, baudrate):
            self.cbxComPortCRB.setCurrentText(comport)
            self.cbxBaudrateCRB.setCurrentText(baudrate)
            self.cbxComPortCRB.setEnabled(False)
            self.cbxBaudrateCRB.setEnabled(False)
            self.btnOpenUartCRB.setEnabled(False)
            self.btnCloseUartCRB.setEnabled(True)            
            return True
        return False
    def CloseUartCRB(self):
        if self.UartCRBClose():
            self.cbxComPortCRB.setEnabled(True)
            self.cbxBaudrateCRB.setEnabled(True)
            self.btnOpenUartCRB.setEnabled(True)
            self.btnCloseUartCRB.setEnabled(False)
            return True
        return False
    #
    #---------------------------------------------------------
    #   Event - UartCRB
    #---------------------------------------------------------
    def btnOpenUartCRB_OnClick(self):
        try:
            if (None != self.UartCRBOpen):
                CI = self.cbxComPortCRB.currentIndex()
                CP = self.cbxComPortCRB.itemText(CI)
                CI = self.cbxBaudrateCRB.currentIndex()
                BR = self.cbxBaudrateCRB.itemText(CI)
                self.OpenUartCRB(CP, BR)                
        except:
            DEF.Error('Open Uart failed');
            pass
        finally:
            self.RefreshComPortsAvailable()
        return    
    def btnCloseUartCRB_OnClick(self):
        try:
            if (None != self.UartCRBClose):
                self.CloseUartCRB()
        except:
            DEF.Error('Close Uart failed');
            pass
        finally:
            self.RefreshComPortsAvailable()
        return    
    #---------------------------------------------------------
    #   Event - LedSystem
    #---------------------------------------------------------
    def LedSystemSetState(self, state):
        if ('On' == state):
            self.lblLedSystem.setText('1')
        elif ('Off' == state):
            self.lblLedSystem.setText('0')
    #
#
