#
import Thread as THR
import CPCDevice as CPCD
#
STATE_SERVO_ERROR         = 0
STATE_SERVO_WARNING       = 1
STATE_SERVO_IDLE          = 2
STATE_SERVO_BUSY          = 3
EStateServo = ['Error', 'Warning', 'Idle', 'Busy']
#
class CServo(CPCD.CDevice):
    #
    def __init__(self, onstatechanged, onpositionchanged): 
        super().__init__()
        self.OnStateChanged = onstatechanged
        self.OnPositionChanged = onpositionchanged
        self.State = STATE_SERVO_IDLE
        self.Thread = None
        
        # ledsystem_onstatechanged,               
        # #self.lblLedSystem.setText('-')
        # self.LedSystem_OnStateChanged = ledsystem_onstatechanged
        # self.Motor_OnStateChanged = motor_onstatechanged
        
        
        return
    #
    def GetStateText(self):
        if (STATE_SERVO_WARNING == self.State):
            return EStateMotor[STATE_MOTOR_WARNING]
        if (STATE_SERVO_IDLE == self.State):
            return EStateMotor[STATE_MOTOR_IDLE]
        if (STATE_SERVO_BUSY == self.State):
            return EStateMotor[STATE_MOTOR_MOVEFORWARD]
        self.State = STATE_SERVO_ERROR
        return EStateServo[STATE_SERVO_ERROR]            
    #
    def SetState(self, state): #int
        if (state != self.State):
            self.State = state
            if (None != self.OnStateChanged):
                self.OnStateChanged(self.State)
    #
    def SetPosition(self, position):
        #debug if (STATE_MOTOR_IDLE == self.State):
        #self.SetState(STATE_MOTOR_MOVEFORWARD)
        return True
        #debug return False
    #
    def SetLow(self):
        #debug if (STATE_MOTOR_IDLE == self.State):
        #self.SetState(STATE_MOTOR_MOVEBACKWARD)
        return True
        #debug return False
    #    
    def SetMedium(self):
        #debug if (self.State in [STATE_MOTOR_MOVEFORWARD, STATE_MOTOR_MOVEBACKWARD]):
        #self.SetState(STATE_MOTOR_ABORTMOTION)
        return True
        #debug return False
    #    
    def SetHigh(self):
        #debug if (self.State in [STATE_MOTOR_MOVEFORWARD, STATE_MOTOR_MOVEBACKWARD]):
        #self.SsetState(STATE_MOTOR_ABORTMOTION)
        return True
        #debug return False
    #
#