//
#include <WiFi.h>
#include "time.h"
//
const char* WIFI_SSID     = "FritzBoxSA7";
const char* WIFI_PASSWORD = "01234567890123456789";
//
const char* NTPTargetServer = "pool.ntp.org";
const long  GMTOffset = 0; // [s]
const int   DayLightOffset = 3600; // [s]
//
struct tm DateTime;
char SBuffer[32];
long unsigned MillisPreset;
//

void DebugDateTime(void)
{
  if(!getLocalTime(&DateTime))
  {
    Serial.println("Error: Cannot access DateTime");
  }
  else
  {
    sprintf(SBuffer, "DataTime[%2.2u%2.2u%2.2u%2.2u%2.2u%2.2u]", 
            DateTime.tm_year - 100, DateTime.tm_mon, DateTime.tm_mday, 
            DateTime.tm_hour, DateTime.tm_min, DateTime.tm_sec);
    Serial.println(SBuffer);
  } 
}


void setup()
{
  Serial.begin(115200);
  Serial.println("\r\n");
  Serial.println("**********************");
  Serial.println("* Esp32NtpServer     *");
  Serial.println("* Version: 01V01     *");
  Serial.println("* Date...: 221102    *");
  Serial.println("* Time...: 1913      *");
  Serial.println("* Author.: OMdevelop *");
  Serial.println("**********************");
  //
  WiFi.disconnect(true);
  WiFi.mode(WIFI_OFF);
  delay(200);
  WiFi.mode(WIFI_MODE_STA);
  Serial.print("Connecting to ");
  Serial.print(WIFI_SSID);
  Serial.print(" : ");
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);  
  while (WiFi.status() != WL_CONNECTED) 
  {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to IPAddress: ");
  Serial.println(WiFi.localIP());
  //
  configTime(GMTOffset, DayLightOffset, NTPTargetServer);
  DebugDateTime();
  //
  // possible to disconnect Wifi - but why???
  // WiFi.disconnect(true);
  // WiFi.mode(WIFI_OFF);
  //
  MillisPreset = millis();
}

void loop()
{
  if (1000 <= (millis() - MillisPreset))
  {
    MillisPreset = millis();
    DebugDateTime();
  }
}
//
//
