//
#include "Define.h"
#include "NtpDateTime.h"
//
const char* WIFI_SSID     = "FritzBoxSA7";
const char* WIFI_PASSWORD = "01234567890123456789";
//
const char* NTPSERVER = "pool.ntp.org";
const long  GMTOFFSET = 0; // [s]
const int   DAYLIGHTOFSET = 3600; // [s]
//
extern char Buffer;
long unsigned MillisPreset;
CNtpDateTime NtpDateTime;
//
void setup()
{
  Serial.begin(115200);
  Message("\r\n");
  Message("**********************");
  Message("* Esp32NtpServer     *");
  Message("* Version: 01V05     *");
  Message("* Date...: 221105    *");
  Message("* Time...: 1259      *");
  Message("* Author.: OMdevelop *");
  Message("**********************");
  //
  NtpDateTime.ConnectWifi(WIFI_SSID, WIFI_PASSWORD);
  NtpDateTime.Initialise(NTPSERVER, GMTOFFSET, DAYLIGHTOFSET);
  //
  // possible to disconnect Wifi - but why???
  // NtpDateTime.DisconnectWifi();
  // NtpDateTime.SetWifiModeOff();
  //
  MillisPreset = millis();
}

void loop()
{
  if (1000 <= (millis() - MillisPreset))
  {
    MillisPreset = millis();
    sprintf(&Buffer, "DateTime[%s]",  NtpDateTime.GetDateTime());
    if (strlen(&Buffer) < 12)
    {
      Error("Cannot access DateTime");
    }
    else
    {
      Message(&Buffer);
    }
  }
}

        

//
//
