//
//----------------------
//  Include
//----------------------
#include <Arduino.h>
//
#include "Define.h"
#include "SDCard.h"
//
//----------------------
//  Definition
//----------------------
const char* FILENAME_DEMO     = "/Example.txt";
const char* DIRECTORY_MAIN    = "/";
const char* DIRECTORY_SUBNEW  = "/SubDirectoryABC";
const char* LINE_SEPARATOR    = "-----------------------------";
const char* FILENAME_NEW      = "/NewFile.new";
//
//----------------------
//  Global
//----------------------
extern char Buffer[];
extern char Line[];
//
CSDCard SDCard(PIN_SPIL_SS, _Message, _Error);
//
//---------------------- 
//  Main - Setup 
//----------------------
void setup()
{ // Initialize SerialPC
  SerialPC.begin(115200);
  delay(333);
  _Message("\r\n\r\n*** Esp32SDCardDemo ***");
  _Message("Version: 02V02");
  _Message("Date   : 221104");
  _Message("Time   : 1207");
  _Message("Author : OMdevelop");
  _Message("");
  //
  //---------------------------------------------
  //  SDCard - Initialise
  //---------------------------------------------
  _Message(LINE_SEPARATOR);
  if (!SDCard.Initialise())
  {
    _Error("Card Mount Failed");
    return;
  }
  _Message("SDCard correct initialised");
  ECardType CT = SDCard.GetCardType();
  if ((ctNone == CT) || (ctUnknown == CT))
  {
    _Error("CardType undefined");
     return;
  }
  _MessageT("CardType: ");
  _Message(CardTypeText(CT));
  sprintf(Line, "CardSize: %lluMB", SDCard.GetCardSizeMB());
  _Message(Line);
  //
  //---------------------------------------------
  //  SDCard - Write to File
  //---------------------------------------------
  _Message(LINE_SEPARATOR);
  _Message("Write File to SDCard:");
  _MessageT("Filename[");
  _MessageT(FILENAME_DEMO);
  _Message("]");
  SDCard.OpenWrite(FILENAME_DEMO);
  //  
  strcpy(Line, "LineA");
  _Message(Line);
  SDCard.WriteLine(Line);
  //  
  strcpy(Line, "LineB");
  _Message(Line);
  SDCard.WriteLine(Line);
  //
  strcpy(Line, "LineC");
  _Message(Line);
  SDCard.WriteLine(Line);
  //  
  SDCard.CloseWrite();
  //
  //---------------------------------------------
  //  SDCard - Read from File
  //---------------------------------------------
  _Message(LINE_SEPARATOR);
  _Message("Read File from SDCard:");
  _MessageT("Filename[");
  _MessageT(FILENAME_DEMO);
  _Message("]");
  SDCard.OpenRead(FILENAME_DEMO);
  //
  while (SDCard.ReadLine(Line))
  {
    _Message(Line);  
  }
  //
  SDCard.CloseRead();
  //
  //---------------------------------------------
  //  SDCard - Directory
  //---------------------------------------------
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "Create Directory[%s]:", DIRECTORY_SUBNEW);
  _Message(Line);
  SDCard.CreateDirectory(DIRECTORY_SUBNEW);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN); 
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "Remove Directory[%s]:", DIRECTORY_SUBNEW);
  _Message(Line);
  SDCard.RemoveDirectory(DIRECTORY_SUBNEW);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN);
  //
  //---------------------------------------------
  //  SDCard - File
  //---------------------------------------------
  _Message(LINE_SEPARATOR);
  sprintf(Buffer, "Rename File[%s -> %s]:", FILENAME_DEMO, FILENAME_NEW);
  _Message(Buffer);
  SDCard.RenameFile(FILENAME_DEMO, FILENAME_NEW);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "Remove File[%s]:", FILENAME_NEW);
  _Message(Line);
  SDCard.RemoveFile(FILENAME_NEW);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN);
  //---------------------------------------------  
  _Message("--- End ---");
}
//
//----------------------
//  Main - Loop
//----------------------
void loop()
{
  // nothing to do
}
