//
//----------------------
//  Include
//----------------------
#include <Arduino.h>
//
#include "Define.h"
#include "SDCard.h"
//
//----------------------
//  Definition
//----------------------
const char* FILENAME_DEMO     = "/Example.txt";
const char* DIRECTORY_MAIN    = "/";
const char* DIRECTORY_SUBYY   = "/22";
const char* DIRECTORY_SUBMM   = "/22/11";
const char* DIRECTORY_SUBDD   = "/22/11/04";
const char* LINE_SEPARATOR    = "-----------------------------";
const char* FILENAME_NEW      = "/NewFile.new";
//
//----------------------
//  Global
//----------------------
extern char Buffer[];
extern char Line[];
//
CSDCard SDCard(PIN_SPIL_SS, _Message, _Error);
//
//---------------------- 
//  Main - Setup 
//----------------------
void setup()
{ // Initialize SerialPC
  SerialPC.begin(115200);
  delay(333);
  _Message("\r\n\r\n*** Esp32SDCardDemo ***");
  _Message("Version: 02V03");
  _Message("Date   : 221104");
  _Message("Time   : 1207");
  _Message("Author : OMdevelop");
  _Message("");
  //
  //---------------------------------------------
  //  SDCard - Initialise
  //---------------------------------------------
  _Message(LINE_SEPARATOR);
  if (!SDCard.Initialise())
  {
    _Error("Card Mount Failed");
    return;
  }
  _Message("SDCard correct initialised");
  ECardType CT = SDCard.GetCardType();
  if ((ctNone == CT) || (ctUnknown == CT))
  {
    _Error("CardType undefined");
     return;
  }
  _MessageT("CardType: ");
  _Message(CardTypeText(CT));
  sprintf(Line, "CardSize: %lluMB", SDCard.GetCardSizeMB());
  _Message(Line); 
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "Create Directory[%s]:", DIRECTORY_SUBYY);
  _Message(Line);
  SDCard.CreateDirectory(DIRECTORY_SUBYY);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "Create Directory[%s]:", DIRECTORY_SUBMM);
  _Message(Line);
  SDCard.CreateDirectory(DIRECTORY_SUBMM);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "Create Directory[%s]:", DIRECTORY_SUBDD);
  _Message(Line);
  SDCard.CreateDirectory(DIRECTORY_SUBDD);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_MAIN);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_MAIN);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_SUBYY);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_SUBYY);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_SUBMM);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_SUBMM);
  //
  _Message(LINE_SEPARATOR);
  sprintf(Line, "List Directory[%s]:", DIRECTORY_SUBDD);
  _Message(Line);
  SDCard.ListDirectory(DIRECTORY_SUBDD);
  //
  _Message("--- end ---");
}

//
//----------------------
//  Main - Loop
//----------------------
void loop()
{
  //...
}

