#
# ------------------------------------------------------------------
#   FrameProtocolUart
# ------------------------------------------------------------------
#   Version: 00V02
#   Date   : 221121
#   Time   : 1200
#   Author : OMDevelop
#
import tkinter as TKI
import tkinter.ttk as TTK
from tkinter import filedialog as TKFD
#
import Define as DEF
#
#------------------------------------------------------------------
#   Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameProtocolUart'
#
NAME_TXTEXT                     = 'TxText'
NAME_COUNTTXENTRIES             = 'CountTxEntries'
MASK_TXENTRY                    = 'Entry'
#
INIT_TXTEXT                     = '-'
INIT_COUNTTXENTRIES             = '0'
INIT_TXENTRY                    = ''
#
HEADER_RXCHARACTER              = ''
HEADER_RXLINE                   = 'RXD>'
HEADER_TXLINE                   = 'TXD>'
#
#------------------------------------------------------------------
#   Type
#------------------------------------------------------------------
class CFrameProtocolUart(TKI.Frame):
    #---------------------------------------------------------------------
    # Constructor
    #---------------------------------------------------------------
    def __init__(self, window):
        TKI.Frame.__init__(self, window, width = 610, height = 532, \
                           padx = 2, pady = 2, bg = "#F2F2F2")
        #
        self.Uart = None
        #
        self.grid_rowconfigure(0, weight = 1) # stretch to windowheight
        # self.grid_rowconfigure(1, weight = 1)
        self.grid_columnconfigure(1, weight = 999) # stretch to windowwidth
        # self.grid_columnconfigure(2, weight = 1)
        #
        #--------------------------------------------------------------
        # Control
        #--------------------------------------------------------------
        self.lbxRxData = TKI.Listbox(self,
                                     font = "Courier 10", activestyle = TKI.NONE)
        self.lbxRxData["selectmode"] = "single"
        self.lbxRxData.grid(row = 0, column = 0, columnspan = 3,
                            sticky = "WENS", padx = 2, pady = 2)
        #
        self.scbRxData = TKI.Scrollbar(self, orient = TKI.VERTICAL)
        self.scbRxData.grid(sticky = "NSW", row = 0, column = 3)
        self.lbxRxData["yscrollcommand"] = self.scbRxData.set
        self.scbRxData["command"] = self.lbxRxData.yview
        #
        self.btnTxData = TKI.Button(self, text = "TxData",
                                 command = self.OnTxData)
        self.btnTxData.grid(row = 1, column = 0, sticky = 'W', padx = 2, pady = 2)
        #
        self.STxData = []
        self.cbxTxData = TTK.Combobox(self, values = self.STxData)
        self.cbxTxData.grid(row = 1, column = 1, sticky = 'EW',
                            columnspan = 3, padx = 2, pady = 2)
        #
        self.ControlsDisable()
        #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------
    def SetLinkUart(self, uart):
        self.Uart = uart
    #
    def ControlsEnable(self):
        try:
            self.lbxRxData.configure(state = 'normal')
            self.btnTxData.configure(state = 'normal')
            self.cbxTxData.configure(state = 'normal')
        except:
            pass
    #
    def ControlsDisable(self):
        try:
            self.lbxRxData.configure(state = 'disable')
            self.btnTxData.configure(state = 'disable')
            self.cbxTxData.configure(state = 'disable')
        except:
            pass
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def OnTxData(self):
        TxLine = self.cbxTxData.get()
        if (TxLine not in self.STxData):
            self.STxData.append(TxLine)
            self.cbxTxData['values'] = self.STxData
        self.AddTxLine(TxLine)
        if (self.Uart.IsOpen()):
            self.Uart.WriteLine(TxLine)
    #
    def UartOnOpen(self):
        self.ControlsEnable()
    #
    def UartOnClose(self):
        self.ControlsDisable()
    #
    # def UartOnDataReceived(self, rxdata):
    #     self.AddRxData(rxdata)
    #     return
    # #
    # def UartOnLineReceived(self, rxline):
    #     self.AddRxLine(rxline)

    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        SValue = readinitdata.ReadValueInit(INITDATA_SECTION, NAME_TXTEXT, INIT_TXTEXT)
        if (0 == len(SValue)):
            SValue = INIT_TXTEXT
        self.cbxTxData.set(SValue)
        #
        SV = readinitdata.ReadValueInit(INITDATA_SECTION,
                                        NAME_COUNTTXENTRIES, INIT_COUNTTXENTRIES)
        CE = int(SV)
        self.STxData = []
        for IE in range(0, CE):
            SE = MASK_TXENTRY + str(IE)
            SValue = readinitdata.ReadValueInit(INITDATA_SECTION,
                                                SE, INIT_TXENTRY)
            if (SValue not in self.STxData):
                self.STxData.append(SValue)
        self.cbxTxData['values'] = self.STxData
        #
        return True
        #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_TXTEXT,
                                 self.cbxTxData.get())

        CE = len(self.STxData)
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_COUNTTXENTRIES, str(CE))
        for IE in range(0, CE):
            SE = MASK_TXENTRY + str(IE)
            writeinitdata.WriteValue(INITDATA_SECTION, SE, self.STxData[IE])
        #
        return True
        #
    #---------------------------------------------------------------
    # Management -
    #--------------------------------------------------------------
    def AddRxData(self, rxdata):
        self.lbxRxData.insert(TKI.END, HEADER_RXCHARACTER + rxdata)
        self.lbxRxData.itemconfig(TKI.END, {'bg':'#eeffcc'}) #{'bg':'#cceeaa'})
    #
    def AddRxLine(self, rxline):
        self.lbxRxData.insert(TKI.END, HEADER_RXLINE + rxline)
        self.lbxRxData.itemconfig(TKI.END, {'bg':'#eeffcc'}) #{'bg':'#cceeaa'})
    #
    def AddTxLine(self, txline):
        self.lbxRxData.insert(TKI.END, HEADER_TXLINE + txline)
        self.lbxRxData.itemconfig(TKI.END, {'bg':'#cceeff'}) # {'bg':'#ffeeaa'})
    #
    def ClearAll(self):
        self.lbxRxData.delete(0, TKI.END)
        self.STxData = []
        self.cbxTxData['values'] = self.STxData
        return
    #
    def WriteToFile(self):
        FT = (('Protocolfiles', '*.txt'),
              ('All files', '*.*'))
        FN = DEF.FILENAME_PROTOCOLUART
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.txt',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            #
            F = open(FN, 'w')
            if (None != F):
                for Line in self.lbxRxData.get(0, TKI.END):
                    F.write(Line + '\r')
                F.close()
                return True
            return False
            #
        return False
    #
    #
#
#







