#
#----------------------------------------------------------------------
#   FrameSystem
#----------------------------------------------------------------------
import tkinter as TKI
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSystemCommon'
#
#NAME_BLINKCOUNT                 = 'BlinkCount'
#INIT_BLINKCOUNT                 = '3'
#------------------------------------------------------------------
class CFrameSystemCommon(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent, bg='red')
        self.FrameParent = frameparent
        self['background'] = '#cccccc'
        BX = 8
        BY = 8
        DX = 84
        DY = 24
        #--------------------------------------------------------
        # System
        #--------------------------------------------------------
        self.lblHeader = TKI.Label(self, text='System')
        self.lblHeader.place(x=BX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.btnReset = TKI.Button(self, text='Reset',
                                   command=self.OnSystemReset)
        self.btnReset.place(x=BX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        #
        self.btnAbort = TKI.Button(self, text='Abort',
                                   command=self.OnSystemAbort)
        self.btnAbort.place(x=BX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        return
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def SetSystemOnReset(self, value):
        self.SystemOnReset = value
    def SetSystemOnAbort(self, value):
        self.SystemOnAbort = value
    #---------------------------------------------------------------------
    # Event
    #---------------------------------------------------------------------
    def OnSystemReset(self):
        if (None != self.SystemOnReset):
            self.SystemOnReset()
    #
    def OnSystemAbort(self):
        if (None != self.SystemOnAbort):
            self.SystemOnAbort()
    #
    #
#
#
