
#
import tkinter as TKI
#
import Define as DEF
import Uart as URT
import FrameApplication as FRA
#
global FrameApplication
global UartController
global GCodeConverter
#

#---------------------------------------------------------
# Main - Function
#---------------------------------------------------------
def OnError(text):
    FrameApplication.ErrorGlobal(text)
def OnProtocol(line):
    FrameApplication.ProtocolGlobal(line)
#------------------------------------------------------------
# Callback - Uart
#------------------------------------------------------------
def UartOnOpen():
    FrameApplication.tbsProtocolUart.ControlsEnable()
    return
def UartOnClose():
    FrameApplication.tbsProtocolUart.ControlsDisable()
    return
def UartOnLineReceived(rxline):
    FrameApplication.tbsProtocolUart.AddRxLine(rxline)
    return
def UartOnLineTransmit(txline):
    FrameApplication.tbsProtocolUart.AddTxLine(txline)
    return
#------------------------------------------------------------
# Callback - FrameSetupGlobal
#------------------------------------------------------------
def FrameSetupGlobalLoadExecuteGCodeFile(filename, report, plot2d,
                                         plot3d, hardware):
    # [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(filename)
    # GCodeExecutor.Start(GCodeList, report, plot2d, plot3d, hardware)
    return
def FrameSetupGlobalAbortExecutionGCodeList():
    # GCodeExecutor.Abort()
    return

#------------------------------------------------------------
# Callback - FrameSystemCommon
#------------------------------------------------------------
def FrameSystemCommonOnReset():
    UartController.WriteLine('RST')
def FrameSystemCommonOnAbort():
    UartController.WriteLine('ABT')
#------------------------------------------------------------
# Callback - FrameSystemLed
#------------------------------------------------------------
def FrameSystemLedOnSetOn():
    UartController.WriteLine('LSO')
def FrameSystemLedOnSetOff():
    UartController.WriteLine('LSF')
def FrameSystemLedOnInvert():
    UartController.WriteLine('LSI')
def FrameSystemLedOnBlink(blinkcount, timeon, timeoff):
    UartController.WriteLine('LSB {0} {1} {2}'.format(blinkcount, timeon, timeoff))
#------------------------------------------------------------
# Callback - Protocol
#------------------------------------------------------------
def FrameProtocolGlobalOnWriteToFile():
    FrameApplication.tbsProtocolGlobal.WriteToFile()
    return
def FrameProtocolGlobalOnClearAll():
    FrameApplication.tbsProtocolGlobal.ClearAll()
    return
# Uart
def FrameProtocolUartOnWriteToFile():
    FrameApplication.tbsProtocolUart.WriteToFile()
    return
def FrameProtocolUartOnClearAll():
    FrameApplication.tbsProtocolUart.ClearAll()
    return
# GCode
def FrameProtocolGCodeOnWriteToFile():
    FrameApplication.tbsProtocolGCode.WriteToFile()
    return
def FrameProtocolGCodeOnClearAll():
    FrameApplication.tbsProtocolGCode.ClearAll()
    return
#---------------------------------------------------------
# Callback - Command
#---------------------------------------------------------
def OnPositionXMoveAbsolute(positionactual, positiontarget):
    print('PX : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionXMoveRelative(positionactual, positiontarget):
    print('PX : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionYMoveAbsolute(positionactual, positiontarget):
    print('PY : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionYMoveRelative(positionactual, positiontarget):
    print('PY : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnPositionZMoveAbsolute(positionactual, positiontarget):
    print('PZ : MoveAbsolute[{0}][{1}]'.format(positionactual, positiontarget))
    return
def OnPositionZMoveRelative(positionactual, positiontarget):
    print('PZ : MoveRelative[{0}][{1}]'.format(positionactual, positiontarget))
    return
#
def OnSpindleRotateIdle():
    print('SP : RotateIdle')
    return
def OnSpindleRotateCW(speed):
    print('SP : RotateCW[{0}]'.format(speed))
    return
def OnSpindleRotateCCW(speed):
    print('SP : RotateCCW[{0}]'.format(speed))
    return
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    try:
        UartController.Close()
        FrameApplication.WriteInitdata(DEF.NAME_INITFILE)
    except:
        pass
#
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
UartController = URT.CUart()
UartController.SetOnOpen(UartOnOpen)
UartController.SetOnClose(UartOnClose)
UartController.SetOnLineReceived(UartOnLineReceived)
UartController.SetOnLineTransmit(UartOnLineTransmit)
#
FrameApplication = FRA.CFrameApplication(TKI.Tk(),
                                         OnFrameApplicationDelete)
FrameApplication.SetOnProtocolGlobalWriteToFile(FrameProtocolGlobalOnWriteToFile)
FrameApplication.SetOnProtocolGlobalClearAll(FrameProtocolGlobalOnClearAll)
FrameApplication.SetOnProtocolUartWriteToFile(FrameProtocolUartOnWriteToFile)
FrameApplication.SetOnProtocolUartClearAll(FrameProtocolUartOnClearAll)
FrameApplication.tbsSetup.FrameSetupUart.SetLinkUart(UartController)
#
PositionX = FrameApplication.tbsPositions.frmPositionX
PositionX.SetOnMoveAbsolute(OnPositionXMoveAbsolute)
PositionX.SetOnMoveRelative(OnPositionXMoveRelative)
#
PositionY = FrameApplication.tbsPositions.frmPositionY
PositionY.SetOnMoveAbsolute(OnPositionYMoveAbsolute)
PositionY.SetOnMoveRelative(OnPositionYMoveRelative)
#
PositionZ = FrameApplication.tbsPositions.frmPositionZ
PositionZ.SetOnMoveAbsolute(OnPositionZMoveAbsolute)
PositionZ.SetOnMoveRelative(OnPositionZMoveRelative)
#
FrameApplication.tbsSystem.frmSystemCommon.SetSystemOnReset(FrameSystemCommonOnReset)
FrameApplication.tbsSystem.frmSystemCommon.SetSystemOnAbort(FrameSystemCommonOnAbort)
#
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnSetOn(FrameSystemLedOnSetOn)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnSetOff(FrameSystemLedOnSetOff)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnInvert(FrameSystemLedOnInvert)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnBlink(FrameSystemLedOnBlink)
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    OnProtocol('*** GCodeInterpreter: begin')
    #
    FrameApplication.Initialise()
    #
    FrameApplication.Execute()
    #
    OnProtocol('*** GCodeInterpreter: end')
#
#
###################################################################
#

