#
#----------------------------------------------------------------------
#   FrameTest
#----------------------------------------------------------------------
import tkinter as TKI
#
import FramePosition as FPN
#import FrameSpindle as FSP
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FramePositions'
#
NAME_VALUE                      = 'Value'
INIT_VALUE                      = '0123'
#----------------------------------------------------------------------
class CFramePositions(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent, bg='red')
        self.FrameParent = frameparent
        self['background'] = '#ccddcc'
        self.BX = 8
        self.BY = 8
        #--------------------------------------------------------
        # PositionX
        #--------------------------------------------------------
        self.frmPositionX = FPN.CFramePosition(self, 100, 122, 96, 76,
                                               'Position X',
                                               'Target [mm]',
                                               'Actual [mm]',
                                               0.0, 1.0)
        self.frmPositionX.place(x=self.BX, y=self.BY,
                                width=100, height=122)
        #--------------------------------------------------------
        # PositionY
        #--------------------------------------------------------
        self.frmPositionY = FPN.CFramePosition(self, 100, 122, 96, 76,
                                               'Position Y',
                                               'Target [mm]',
                                               'Actual [mm]',
                                               0.0, 1.0)

        self.frmPositionY.place(x=100+2*self.BX, y=self.BY,
                                width=100, height=122)
        #--------------------------------------------------------
        # PositionZ
        #--------------------------------------------------------
        self.frmPositionZ = FPN.CFramePosition(self, 100, 122, 96, 76,
                                               'Position Z',
                                               'Target [mm]',
                                               'Actual [mm]',
                                               0.0, 1.0)
        self.frmPositionZ.place(x=200+3*self.BX, y=self.BY,
                                width=100, height=122)
        #--------------------------------------------------------
        # Abort
        #--------------------------------------------------------
        self.btnAbortAll = TKI.Button(self, text='Abort All',
                                     command=self.OnAbortAll)
        self.btnAbortAll.place(x=500+self.BX, y=0 + self.BY, width=600,
                               height=200, anchor='sw')

        return
    #
    def SetPositionsTarget(self, ptx, pty, ptz):
        self.frmPositionX.SetPositionTarget(ptx)
        self.frmPositionY.SetPositionTarget(pty)
        self.frmPositionZ.SetPositionTarget(ptz)
    #
    def SetPositionsActual(self, pax, pay, paz):
        self.frmPositionX.SetPositionActual(pax)
        self.frmPositionY.SetPositionActual(pay)
        self.frmPositionZ.SetPositionActual(paz)
    #
    def OnAbortAll(self):
        return
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        print(readinitdata.ReadValueInit(INITDATA_SECTION, NAME_VALUE, INIT_VALUE));
        return True
    #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_VALUE, '9876')
        return True
    #
    #
#
#
