#
#----------------------------------------------------------------------
#   FrameSystem
#----------------------------------------------------------------------
import tkinter as TKI
#
import FrameSystemCommon as FSC
import FrameSystemLed as FSL
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSystem'
#
#----------------------------------------------------------------------
class CFrameSystem(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent, bg='red')
        self.FrameParent = frameparent
        self['background'] = '#ccddcc'
        BX = 8
        BY = 8
        SX = 100
        SY = 104
        #--------------------------------------------------------
        # SystemCommon
        #--------------------------------------------------------
        self.frmSystemCommon = FSC.CFrameSystemCommon(self)
        self.frmSystemCommon.place(x=BX, y=BY, width=SX, height=SY)
        #--------------------------------------------------------
        # SystemLed
        #--------------------------------------------------------
        self.frmSystemLed = FSL.CFrameSystemLed(self)
        self.frmSystemLed.place(x=2*BX+SX, y=BY, width=3.75*SX, height=SY)
        #
        return
    #
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        self.frmSystemLed.ReadInitdata(readinitdata)
        return True
    #
    def WriteInitdata(self, writeinitdata):
        self.frmSystemLed.WriteInitdata(writeinitdata)
        return True
    #
    #
#
#
