import tkinter as TKI
from tkinter import ttk as TTK
from tkinter import messagebox as TKMB
from tkinter import filedialog as TKFD
#
import Define as DEF
import Initdata as ID
import FrameSetup as FSU
import FrameProtocolGlobal as FPC
import FrameProtocolUart as FPU
import FrameSystem as FST
import FramePositions as FPSN
#
TITLE_APPLICATION = 'FrameHierarchy'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, onframeapplicationdelete):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        self.FrameParent.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        #self.FrameParent.rowconfigure(0, weight=1)
        #self.FrameParent.columnconfigure(0, weight=1)
        self.FrameParent.geometry('804x626+66+66')
        #self.FrameParent.geometry('804x626+2022+33')
        self.FrameParent.title(DEF.APPLICATION_TITLE)
        #
        self.IsActive = False
        #--------------------------------------------------------
        # Menu
        #--------------------------------------------------------
        self.Menu = TKI.Menu(self.FrameParent)
        self.FrameParent.config(menu = self.Menu)
        # Menu - System
        self.MenuSystem = TKI.Menu(self.Menu, tearoff=0)
        self.Menu.add_cascade(label = "System", menu = self.MenuSystem)
        self.MenuSystem.add_command(label = "Read Initfile Default", \
                                    command = self.OnReadInitfileDefault)
        self.MenuSystem.add_command(label = "Read Initfile Dialog", \
                                    command = self.OnReadInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Write Initfile Default", \
                                    command = self.OnWriteInitfileDefault)
        self.MenuSystem.add_command(label = "Write Initfile Dialog", \
                                    command = self.OnWriteInitfileDialog)
        self.MenuSystem.add_command(label = "Exit Application", \
                                    command = self.OnExitApplication)
        # Menu - Device
        self.MenuDevice = TKI.Menu(self.Menu, tearoff=0)
        self.Menu.add_cascade(label = "Protocol", menu = self.MenuDevice)
        self.MenuDevice.add_command(label = "Global", state="disabled")
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolGlobalWriteToFile)
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolGlobalClearAll)
        self.MenuDevice.add_separator()
        self.MenuDevice.add_command(label = "Uart", state="disabled")
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolUartWriteToFile)
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolUartClearAll)
        # Menu - Help
        self.MenuHelp = TKI.Menu(self.Menu, tearoff=0)
        self.Menu.add_cascade(label = "Help", menu = self.MenuHelp)
        self.MenuHelp.add_command(label = "Show About", command = self.OnShowAbout)
        #--------------------------------------------------------
        # Notebook
        #--------------------------------------------------------
        self.ntbView = TTK.Notebook(self.FrameParent)
        self.ntbView.place(x=3, y=0, width=800, height=600)
        #--------------------------------------------------------
        # Notebook - Tabsheet - Protocol
        #--------------------------------------------------------
        self.tbsProtocolGlobal = FPC.CFrameProtocolGlobal(self.ntbView)
        self.ntbView.add(self.tbsProtocolGlobal, text='ProtocolGlobal')
        #--------------------------------------------------------
        # Notebook - Tabsheet - Setup
        #--------------------------------------------------------
        self.tbsSetup = FSU.CFrameSetup(self.ntbView)
        self.ntbView.add(self.tbsSetup, text = "Setup")
        #-------------------------------------------------------------------------------
        # Notebook - Tabsheet - UartDataflow
        #-------------------------------------------------------------------------------
        self.tbsProtocolUart = FPU.CFrameProtocolUart(self.ntbView)
        self.ntbView.add(self.tbsProtocolUart, text="ProtocolUart")
        #--------------------------------------------------------
        # FrameCommand (11)
        #--------------------------------------------------------
        self.ntbCommands = TTK.Notebook(self.FrameParent)
        self.ntbCommands.place(x=4, y=600, width=800, height=266)
        #--------------------------------------------------------
        self.tbsSystem= FST.CFrameSystem(self.FrameParent)
        self.ntbCommands.add(self.tbsSystem, text='System')
        #--------------------------------------------------------
        self.tbsPositions= FPSN.CFramePositions(self.FrameParent)
        self.ntbCommands.add(self.tbsPositions, text='Positions')
        #--------------------------------------------------------
        self.PProtocolGlobalWriteToFile = None
        self.PProtocolGlobalClearAll = None
        self.PProtocolUartWriteToFile = None
        self.PProtocolUartClearAll = None
        #
        return
    #---------------------------------------------------------------------
    # CApplication - Property
    #---------------------------------------------------------------------
    def SetOnProtocolGlobalWriteToFile(self, onprotocolglobalwritetofile):
        self.PProtocolGlobalWriteToFile = onprotocolglobalwritetofile
    def SetOnProtocolGlobalClearAll(self, onprotocolglobalclearall):
        self.PProtocolGlobalClearAll = onprotocolglobalclearall
    def SetOnProtocolUartWriteToFile(self, onprotocoluartwritetofile):
        self.PProtocolUartWriteToFile = onprotocoluartwritetofile
    def SetOnProtocolUartClearAll(self, onprotocoluartclearall):
        self.PProtocolUartClearAll = onprotocoluartclearall
    #---------------------------------------------------------------------
    # CApplication - Initdata
    #---------------------------------------------------------------------
    def Initialise(self):
        self.IsActive = True
        self.ProtocolGlobal('CFrameApplication.Initialise')
        self.ReadInitdata(DEF.NAME_INITFILE)
        return
    #
    def ReadInitdata(self, filename):
        self.ProtocolGlobal('CFrameApplication.ReadInitdata: begin')
        RID = ID.CReadInitdata()
        RID.Open(filename)
        X = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_X, DEF.INIT_X)
        Y = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_Y, DEF.INIT_Y)
        W = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_W, DEF.INIT_W)
        H = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_H, DEF.INIT_H)
        self.FrameParent.geometry('%dx%d+%d+%d' % (int(W), int(H), int(X), int(Y)))
        #
        STI = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX,
                                DEF.INIT_SELECTTABINDEX)
        self.ntbView.select(int(STI))
        #
        self.tbsProtocolGlobal.ReadInitdata(RID)
        self.tbsSetup.ReadInitdata(RID)
        self.tbsProtocolUart.ReadInitdata(RID)
        #
        self.tbsSystem.ReadInitdata(RID)
        self.tbsPositions.ReadInitdata(RID)
        #
        RID.Close()
        self.ProtocolGlobal('CFrameApplication.ReadInitdata: end')
        return
    #
    def WriteInitdata(self, filename):
        self.ProtocolGlobal('CFrameApplication.WriteInitdata: begin')
        WID = ID.CWriteInitdata()
        WID.Open(filename)
        X = self.FrameParent.winfo_x()
        Y = self.FrameParent.winfo_y()
        W = self.FrameParent.winfo_width()
        H = self.FrameParent.winfo_height()
        WID.WriteSection(DEF.INITDATA_SECTION)
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_X, str(X))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_Y, str(Y))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_W, str(W))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_H, str(H))
        #
        STI = self.ntbView.index('current')
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, str(STI))
        #
        self.tbsProtocolGlobal.WriteInitdata(WID)
        self.tbsSetup.WriteInitdata(WID)
        self.tbsProtocolUart.WriteInitdata(WID)
        #
        self.tbsSystem.WriteInitdata(WID)
        self.tbsPositions.WriteInitdata(WID)
        #
        WID.Close()
        self.ProtocolGlobal('CFrameApplication.WriteInitdata: end')
        return
    #---------------------------------------------------------------------
    # CApplication - Helper
    #---------------------------------------------------------------------
    def ErrorGlobal(self, text):
        if (self.IsActive):
            self.tbsProtocolGlobal.Error(text)
            TKMB.showerror('Error', text)
        return
    def ProtocolGlobal(self, line):
        if (self.IsActive):
            self.tbsProtocolGlobal.Line(line)
        return
    #---------------------------------------------------------------------
    # CApplication - Callback / Event
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        self.IsActive = False
        self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameParent.destroy()
        return
    #
    def OnReadInitfileDefault(self):
        self.ReadInitdata(DEF.NAME_INITFILE)
        return
    #
    def OnReadInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FN = TKFD.askopenfilename(title = 'Read Initfile',
                                  initialdir = '../TerminalUart',
                                  filetypes = FT)
        self.ReadInitdata(FN)
        return
    #
    def OnWriteInitfileDefault(self):
        self.WriteInitdata(DEF.NAME_INITFILE)
        return
    #
    def OnWriteInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.ini',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.WriteInitdata(FN)
        return
    #
    def OnProtocolGlobalWriteToFile(self):
        if (None != self.PProtocolGlobalWriteToFile):
            self.PProtocolGlobalWriteToFile()
        return
    def OnProtocolGlobalClearAll(self):
        if (None != self.PProtocolGlobalClearAll):
            self.PProtocolGlobalClearAll()
        return
    #
    def OnProtocolUartWriteToFile(self):
        if (None != self.PProtocolUartWriteToFile):
            self.PProtocolUartWriteToFile()
        return
    def OnProtocolUartClearAll(self):
        if (None != self.PProtocolUartClearAll):
            self.PProtocolUartClearAll()
        return
    def OnShowAbout(self):
        TKMB.showinfo("About", DEF.INFO_ABOUT)
    #
    def OnExitApplication(self):
        self.OnWMDeleteWindow()
    #---------------------------------------------------------------------
    # CApplication - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameParent.mainloop()
    #
    #
#
#
