
#
import tkinter as TKI
#
import Define as DEF
import Uart as URT
import FrameApplication as FRA
#
global FrameApplication
global UartController
global GCodeConverter
#

#---------------------------------------------------------
# Main - Function
#---------------------------------------------------------
def OnError(text):
    FrameApplication.Error(text)
def OnProtocol(line):
    FrameApplication.Protocol(line)
#------------------------------------------------------------
# Callback - Uart
#------------------------------------------------------------
def UartOnOpen():
    FrameApplication.tbsUart.FrameUartProtocol.ControlsEnable()
    return
def UartOnClose():
    FrameApplication.tbsUart.FrameUartProtocol.ControlsDisable()
    return
def UartOnLineReceived(rxline):
    FrameApplication.tbsUart.FrameUartProtocol.AddRxLine(rxline)
    # ...FrameApplication.
    return
def UartOnLineTransmit(txline):
    FrameApplication.tbsUart.FrameUartProtocol.AddTxLine(txline)
    return
#------------------------------------------------------------
# Callback - FrameSetupGlobal
#------------------------------------------------------------

#------------------------------------------------------------
# Callback - FrameSystemCommon
#------------------------------------------------------------
def FrameSystemCommonOnReset():
    UartController.WriteLine('RST')
def FrameSystemCommonOnAbort():
    UartController.WriteLine('ABT')
#------------------------------------------------------------
# Callback - FrameSystemLed
#------------------------------------------------------------
def FrameSystemLedOnSetOn():
    UartController.WriteLine('LSO')
def FrameSystemLedOnSetOff():
    UartController.WriteLine('LSF')
def FrameSystemLedOnInvert():
    UartController.WriteLine('LSI')
def FrameSystemLedOnBlink(blinkcount, timeon, timeoff):
    UartController.WriteLine('LSB {0} {1} {2}'.format(blinkcount, timeon, timeoff))
#------------------------------------------------------------
# Callback - Protocol
#------------------------------------------------------------
def FrameProtocolOnWriteToFile():
    FrameApplication.tbsProtocol.WriteToFile()
    return
def FrameProtocolOnClearAll():
    FrameApplication.tbsProtocol.ClearAll()
    return
# Uart
def FrameProtocolUartOnWriteToFile():
    FrameApplication.tbsProtocolUart.WriteToFile()
    return
def FrameProtocolUartOnClearAll():
    FrameApplication.tbsProtocolUart.ClearAll()
    return
# GCode
def FrameProtocolGCodeOnWriteToFile():
    FrameApplication.tbsProtocolGCode.WriteToFile()
    return
def FrameProtocolGCodeOnClearAll():
    FrameApplication.tbsProtocolGCode.ClearAll()
    return
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    try:
        UartController.Close()
        FrameApplication.WriteInitdata(DEF.NAME_INITFILE)
    except:
        pass
#
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
UartController = URT.CUart()
UartController.SetOnOpen(UartOnOpen)
UartController.SetOnClose(UartOnClose)
UartController.SetOnLineReceived(UartOnLineReceived)
UartController.SetOnLineTransmit(UartOnLineTransmit)
#
FrameApplication = FRA.CFrameApplication(TKI.Tk(),
                                         OnFrameApplicationDelete)
FrameApplication.SetOnProtocolWriteToFile(FrameProtocolOnWriteToFile)
FrameApplication.SetOnProtocolClearAll(FrameProtocolOnClearAll)
FrameApplication.SetOnProtocolUartWriteToFile(FrameProtocolUartOnWriteToFile)
FrameApplication.SetOnProtocolUartClearAll(FrameProtocolUartOnClearAll)
#
FrameApplication.tbsSystem.frmSystemCommon.SetSystemOnReset(FrameSystemCommonOnReset)
FrameApplication.tbsSystem.frmSystemCommon.SetSystemOnAbort(FrameSystemCommonOnAbort)
#
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnSetOn(FrameSystemLedOnSetOn)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnSetOff(FrameSystemLedOnSetOff)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnInvert(FrameSystemLedOnInvert)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnBlink(FrameSystemLedOnBlink)
#
FrameApplication.tbsUart.FrameUartSetup.SetLinkUart(UartController)
FrameApplication.tbsUart.FrameUartProtocol.SetLinkUart(UartController)
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    OnProtocol('*** GCodeInterpreter: begin')
    #
    FrameApplication.Initialise()
    #
    FrameApplication.Execute()
    #
    OnProtocol('*** GCodeInterpreter: end')
#
#
###################################################################
#

