#
#----------------------------------------------------------------------
#   FrameSystem
#----------------------------------------------------------------------
import tkinter as TKI
#
import FrameSystemCommon as FSC
import FrameSystemLed as FSL
import FrameSystemLedState as FSLS
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSystem'
#
#----------------------------------------------------------------------
class CFrameSystem(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent, bg='red')
        self.FrameParent = frameparent
        self['background'] = '#ccddcc'
        BX = 8
        BY = 8
        SX = 100
        SY = 104
        #--------------------------------------------------------
        # SystemCommon
        #--------------------------------------------------------
        self.frmSystemCommon = FSC.CFrameSystemCommon(self)
        self.frmSystemCommon.place(x=BX, y=BY, width=3*SX, height=SY)
        #--------------------------------------------------------
        # SystemLed
        #--------------------------------------------------------
        self.frmSystemLed = FSL.CFrameSystemLed(self)
        self.frmSystemLed.place(x=BX, y=120, width=3.75*SX, height=SY)
        #
        self.frmSystemLedState = FSLS.CFrameSystemLedState(self, 100, 100)
        self.frmSystemLedState.place(x=BX+380, y=120, width=100, height=104)
        #
        self.ControlsDisable()
        #
        return
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def ControlsEnable(self):
        self.frmSystemCommon.lblHeader.configure(state = 'normal')
        self.frmSystemCommon.btnReset.configure(state = 'normal')
        self.frmSystemCommon.btnAbort.configure(state = 'normal')
        self.frmSystemCommon.lblController.configure(state = 'normal')
        self.frmSystemCommon.lblTicks.configure(state = 'normal')
        self.frmSystemCommon.lblUnit.configure(state = 'normal')
        self.frmSystemCommon.btnRefresh.configure(state = 'normal')
        self.frmSystemCommon.sbxInterval.configure(state = 'normal')
        self.frmSystemCommon.lblInterval.configure(state = 'normal')
        #
        self.frmSystemLed.lblHeader.configure(state = 'normal')
        self.frmSystemLed.btnSetOn.configure(state = 'normal')
        self.frmSystemLed.btnSetOff.configure(state = 'normal')
        self.frmSystemLed.btnInvert.configure(state = 'normal')
        self.frmSystemLed.lblCount.configure(state = 'normal')
        self.frmSystemLed.lblTimeOn.configure(state = 'normal')
        self.frmSystemLed.lblTimeOff.configure(state = 'normal')
        self.frmSystemLed.btnBlink.configure(state = 'normal')
        self.frmSystemLed.sbxCount.configure(state = 'normal')
        self.frmSystemLed.sbxTimeOn.configure(state = 'normal')
        self.frmSystemLed.sbxTimeOff.configure(state = 'normal')
        #
        self.frmSystemLedState.lblBottom.configure(state = 'normal')
        self.frmSystemLedState.lblImage.configure(state = 'normal')
        return
    def ControlsDisable(self):
        self.frmSystemCommon.lblHeader.configure(state = 'disable')
        self.frmSystemCommon.btnReset.configure(state = 'disable')
        self.frmSystemCommon.btnAbort.configure(state = 'disable')
        self.frmSystemCommon.lblController.configure(state = 'disable')
        self.frmSystemCommon.lblTicks.configure(state = 'disable')
        self.frmSystemCommon.lblUnit.configure(state = 'disable')
        self.frmSystemCommon.btnRefresh.configure(state = 'disable')
        self.frmSystemCommon.sbxInterval.configure(state = 'disable')
        self.frmSystemCommon.lblInterval.configure(state = 'disable')
        #
        self.frmSystemLed.lblHeader.configure(state = 'disable')
        self.frmSystemLed.btnSetOn.configure(state = 'disable')
        self.frmSystemLed.btnSetOff.configure(state = 'disable')
        self.frmSystemLed.btnInvert.configure(state = 'disable')
        self.frmSystemLed.lblCount.configure(state = 'disable')
        self.frmSystemLed.lblTimeOn.configure(state = 'disable')
        self.frmSystemLed.lblTimeOff.configure(state = 'disable')
        self.frmSystemLed.btnBlink.configure(state = 'disable')
        self.frmSystemLed.sbxCount.configure(state = 'disable')
        self.frmSystemLed.sbxTimeOn.configure(state = 'disable')
        self.frmSystemLed.sbxTimeOff.configure(state = 'disable')
        #
        self.frmSystemLedState.lblBottom.configure(state = 'disable')
        self.frmSystemLedState.lblImage.configure(state = 'disable')
        return
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        self.frmSystemLed.ReadInitdata(readinitdata)
        return True
    #
    def WriteInitdata(self, writeinitdata):
        self.frmSystemLed.WriteInitdata(writeinitdata)
        return True
    #
    #
#
#
