#
#----------------------------------------------------------------------
#   FrameSystem
#----------------------------------------------------------------------
import tkinter as TKI
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSystemCommon'
#
NAME_REFRESHINTERVAL            = 'RefreshInterval'
INIT_REFRESHINTERVAL            = '1000'
#------------------------------------------------------------------
class CFrameSystemCommon(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent, bg='red')
        self.FrameParent = frameparent
        self['background'] = '#cccccc'
        BX = 8
        BY = 8
        DX = 84
        DY = 24
        self.RI = TKI.IntVar()
        self.RI.set(INIT_REFRESHINTERVAL)
        #
        self.SystemOnReset = None
        self.SystemOnAbort = None
        self.SystemOnRefreshInterval = None
        #--------------------------------------------------------
        # System
        #--------------------------------------------------------
        # ROW 0
        self.lblHeader = TKI.Label(self, text='System')
        self.lblHeader.place(x=BX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.btnReset = TKI.Button(self, text='Reset',
                                   command=self.OnSystemReset)
        self.btnReset.place(x=2*BX+DX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.btnAbort = TKI.Button(self, text='Abort',
                                   command=self.OnSystemAbort)
        self.btnAbort.place(x=3*BX+2*DX, y=BY, width=DX, height=DY, anchor='nw')
        # ROW 1
        self.lblController = TKI.Label(self, text='Controller')
        self.lblController.place(x=BX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        #
        self.lblTicks = TKI.Label(self, text='0')
        self.lblTicks.place(x=2*BX+DX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        #
        self.lblUnit = TKI.Label(self, text='Ticks[s.ms]')
        self.lblUnit.place(x=3*BX+2*DX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        # ROW 2
        self.btnRefresh = TKI.Button(self, text='Refresh',
                                     command=self.OnRefreshInterval)
        self.btnRefresh.place(x=BX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        #
        self.sbxInterval = TKI.Spinbox(self, from_=1, to=1000000, justify='center',
                                       textvariable=self.RI)
        self.sbxInterval.place(x=2*BX+DX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        #
        self.lblInterval = TKI.Label(self, text='Interval[ms]', justify='center')
        self.lblInterval.place(x=3*BX+2*DX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        #
        return
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def SetSystemOnReset(self, value):
        self.SystemOnReset = value
    def SetSystemOnAbort(self, value):
        self.SystemOnAbort = value
    def SetSystemOnRefreshInterval(self, value):
        self.SystemOnRefreshInterval = value
    def SetControllerTicks(self, value):
        self.lblTicks.config(text = '%6.3f' % value)
    #---------------------------------------------------------------------
    # Event
    #---------------------------------------------------------------------
    def OnSystemReset(self):
        if (None != self.SystemOnReset):
            self.SystemOnReset()
    #
    def OnSystemAbort(self):
        if (None != self.SystemOnAbort):
            self.SystemOnAbort()
    #
    def OnRefreshInterval(self):
        if (None != self.SystemOnRefreshInterval):
            self.SystemOnRefreshInterval(self.RI.get())
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        self.RI.set(int(readinitdata.ReadValueInit(INITDATA_SECTION,
                                                   NAME_REFRESHINTERVAL,
                                                   INIT_REFRESHINTERVAL)));
        return True
    #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        writeinitdata.WriteValue(INITDATA_SECTION,
                                 NAME_REFRESHINTERVAL, str(self.RI.get()))
        return True
    #
    #
#
#
