import tkinter as TKI
from PIL import Image, ImageTk
from enum import Enum as ENM
#
class EStateLed(ENM):
    sldOff = 0
    sldOn = 1
#
class CFrameSystemLedState(TKI.Frame):
    def __init__(self, frameparent, width, height):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        #
        self.BottomOff = 'LedSystem: OFF'
        self.CommandOff = 'Switch ON'
        self.BottomOn = 'LedSystem: ON'
        self.CommandOn = 'Switch OFF'
        #
        self.SX = width
        self.SY = height
        self.DY = 22
        #
        self.lblBottom = TKI.Label(self, text=self.BottomOff)
        self.lblBottom.place(x=0, y=self.SY-self.DY, width=self.SX,
                             height=self.DY, anchor='nw')
        #
        IMGOff = Image.open("ressource/LedSystemOff.png").resize((64, 64),
                                                                 Image.NEAREST)
        self.imgOff = ImageTk.PhotoImage(IMGOff)
        IMGOn = Image.open("ressource/LedSystemOn.png").resize((64, 64),
                                                               Image.NEAREST)
        self.imgOn = ImageTk.PhotoImage(IMGOn)
        #
        self.lblImage = TKI.Label(self)
        self.lblImage.place(x=0, y=self.DY / 2, width=100, height=64)
        #
        self.SetState(EStateLed.sldOff)
        return
    #
    def SetState(self, state):
        self.State = state
        if (EStateLed.sldOn == state):
            self.lblImage['image'] = self.imgOn
            self.lblBottom['text'] = self.BottomOn
            return
        self.lblImage['image'] = self.imgOff
        self.lblBottom['text'] = self.BottomOff
        return

    #
    #
#
#

