#
#----------------------------------------------------------------------
#   FrameSystem
#----------------------------------------------------------------------
import tkinter as TKI
#
#------------------------------------------------------------------
#   Global Constant
#------------------------------------------------------------------
INITDATA_SECTION                = 'FrameSystemLed'
#
NAME_BLINKCOUNT                 = 'BlinkCount'
NAME_TIMEON                     = 'BlinkTimeOn'
NAME_TIMEOFF                    = 'BlinkTimeOff'
INIT_BLINKCOUNT                 = '3'
INIT_TIMEON                     = '0333' # [ms]
INIT_TIMEOFF                    = '0555' # [ms]
#------------------------------------------------------------------
class CFrameSystemLed(TKI.Frame):
    #
    def __init__(self, frameparent):
        super().__init__(frameparent, bg='red')
        self.FrameParent = frameparent
        self['background'] = '#cccccc'
        #
        self.LedSystemOnSetOn = None
        self.LedSystemOnSetOff = None
        self.LedSystemOnInvert = None
        self.LedSystemOnBlink = None
        #
        BX = 8
        BY = 8
        DX = 84
        DY = 24
        self.BC = TKI.IntVar()
        self.BC.set(INIT_BLINKCOUNT)
        self.TO = TKI.IntVar()
        self.TO.set(INIT_TIMEON)
        self.TF = TKI.IntVar()
        self.TF.set(INIT_TIMEOFF)
        #--------------------------------------------------------
        # LedSystem
        #--------------------------------------------------------
        self.lblHeader = TKI.Label(self, text='LedSystem')
        self.lblHeader.place(x=BX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.btnSetOn = TKI.Button(self, text='Set ON',
                                   command=self.OnSetOn)
        self.btnSetOn.place(x=2*BX+DX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.btnSetOff = TKI.Button(self, text='Set OFF',
                                    command=self.OnSetOff)
        self.btnSetOff.place(x=3*BX+2*DX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.btnInvert = TKI.Button(self, text='Invert',
                                    command=self.OnInvert)
        self.btnInvert.place(x=4*BX+3*DX, y=BY, width=DX, height=DY, anchor='nw')
        #
        self.lblCount = TKI.Label(self, text='Count', justify='center')
        self.lblCount.place(x=2*BX+DX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        #
        self.lblTimeOn = TKI.Label(self, text='TimeOn[ms]', justify='center')
        self.lblTimeOn.place(x=3*BX+2*DX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        #
        self.lblTimeOff = TKI.Label(self, text='TimeOn[ms]', justify='center')
        self.lblTimeOff.place(x=4*BX+3*DX, y=2*BY+DY, width=DX, height=DY, anchor='nw')
        #
        self.btnBlink = TKI.Button(self, text='Blink',
                                   command=self.OnBlink)
        self.btnBlink.place(x=BX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        #
        self.sbxCount = TKI.Spinbox(self, from_=1, to=1000000, justify='center',
                                    textvariable=self.BC)
        self.sbxCount.place(x=2*BX+DX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        #
        self.sbxTimeOn = TKI.Spinbox(self, from_=1, to=1000000, justify='center',
                                     textvariable=self.TO)
        self.sbxTimeOn.place(x=3*BX+2*DX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
        #
        self.sbxTimeOff = TKI.Spinbox(self, from_=1, to=1000000, justify='center',
                                      textvariable=self.TF)
        self.sbxTimeOff.place(x=4*BX+3*DX, y=3*BY+2*DY, width=DX, height=DY, anchor='nw')
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def SetLedSystemOnSetOn(self, value):
        self.LedSystemOnSetOn = value
    def SetLedSystemOnSetOff(self, value):
        self.LedSystemOnSetOff = value
    def SetLedSystemOnInvert(self, value):
        self.LedSystemOnInvert = value
    def SetLedSystemOnBlink(self, value):
        self.LedSystemOnBlink = value
    #---------------------------------------------------------------------
    # Event
    #---------------------------------------------------------------------
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def OnSetOn(self):
        if (None != self.LedSystemOnSetOn):
            self.LedSystemOnSetOn()
        return
    #
    def OnSetOff(self):
        if (None != self.LedSystemOnSetOff):
            self.LedSystemOnSetOff()
        return
    #
    def OnInvert(self):
        if (None != self.LedSystemOnInvert):
            self.LedSystemOnInvert()
        return
    #
    def OnBlink(self):
        if (None != self.LedSystemOnBlink):
            self.LedSystemOnBlink(self.BC.get(), self.TO.get(), self.TF.get())
        return
    #---------------------------------------------------------------------
    # Initdata
    #---------------------------------------------------------------------
    def ReadInitdata(self, readinitdata):
        self.BC.set(int(readinitdata.ReadValueInit(INITDATA_SECTION,
                                                   NAME_BLINKCOUNT,
                                                   INIT_BLINKCOUNT)));
        self.TO.set(int(readinitdata.ReadValueInit(INITDATA_SECTION,
                                                   NAME_TIMEON,
                                                   INIT_TIMEON)));
        self.TF.set(int(readinitdata.ReadValueInit(INITDATA_SECTION,
                                                   NAME_TIMEOFF,
                                                   INIT_TIMEOFF)));
        return True
    #
    def WriteInitdata(self, writeinitdata):
        writeinitdata.WriteSection(INITDATA_SECTION)
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_BLINKCOUNT, str(self.BC.get()))
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_TIMEON, str(self.TO.get()))
        writeinitdata.WriteValue(INITDATA_SECTION, NAME_TIMEOFF, str(self.TF.get()))
        return True
    #
    #
#
#
