#
import tkinter as TKI
#
import Define as DEF
import Uart as URT
import FrameApplication as FRA
import FrameSystemLedState as FSLS
#
global FrameApplication
#---------------------------------------------------------
# Main - Function
#---------------------------------------------------------
def OnError(text):
    FrameApplication.Error(text)
def OnProtocol(line):
    FrameApplication.Protocol(line)
#
def SystemOnAbort():
    UartController.Abort()
#------------------------------------------------------------
# Callback - Uart
#------------------------------------------------------------
def UartOnOpen():
    FrameApplication.tbsUart.FrameUartProtocol.ControlsEnable()
    FrameApplication.tbsSystem.ControlsEnable()
    return
def UartOnClose():
    FrameApplication.tbsUart.FrameUartProtocol.ControlsDisable()
    FrameApplication.tbsSystem.ControlsDisable()
    return
def UartOnLineReceived(rxline):
    # ':xxx' in Uart RxLine respected
    FrameApplication.tbsUart.FrameUartProtocol.AddRxLine(rxline)
    if ('!Error:' in rxline):
        OnProtocol(rxline)
        SystemOnAbort() # reenable Handshake
        Text = rxline[8:-1]
        OnError(Text)
        return
    if ('!SYS' in rxline):
        Text = rxline[5:]
        Tokens = Text.split(' ')
        #debug print('>>>', Tokens)
        FRM = FrameApplication.tbsSystem.frmSystemCommon
        FRM.SetControllerTicks(float(Tokens[0]) / 1000.0)
        return
    if ('!LSO' == rxline):
        FRM = FrameApplication.tbsSystem.frmSystemLedState
        FRM.SetState(FSLS.EStateLed.sldOn)
        return
    if ('!LSF' == rxline):
        FRM = FrameApplication.tbsSystem.frmSystemLedState
        FRM.SetState(FSLS.EStateLed.sldOff)
        return
    return
def UartOnLineTransmit(txline):
    FrameApplication.tbsUart.FrameUartProtocol.AddTxLine(txline)
    return
#------------------------------------------------------------
# Callback - FrameSetupGlobal
#------------------------------------------------------------
def FrameUartProtocolOnTransmitLine(txline):
    UartController.TransmitLine(txline)
#------------------------------------------------------------
# Callback - FrameSystemCommon
#------------------------------------------------------------
def FrameSystemCommonOnReset():
    UartController.TransmitLine('R')
def FrameSystemCommonOnAbort():
    UartController.TransmitLine('A')
def FrameSystemCommonOnRefreshInterval(interval):
    UartController.TransmitLine('SRI {0}'.format(interval))
#------------------------------------------------------------
# Callback - FrameSystemLed
#------------------------------------------------------------
def FrameSystemLedOnSetOn():
    UartController.TransmitLine('LSO')
def FrameSystemLedOnSetOff():
    UartController.TransmitLine('LSF')
def FrameSystemLedOnInvert():
    UartController.TransmitLine('LSI')
def FrameSystemLedOnBlink(blinkcount, timeon, timeoff):
    UartController.TransmitLine('LSB {0} {1} {2}'.format(blinkcount, timeon, timeoff))
#------------------------------------------------------------
# Callback - Protocol
#------------------------------------------------------------
def FrameProtocolOnWriteToFile():
    FrameApplication.tbsProtocol.WriteToFile()
    return
def FrameProtocolOnClearAll():
    FrameApplication.tbsProtocol.ClearAll()
    return
# Uart
def FrameProtocolUartOnWriteToFile():
    FrameApplication.tbsProtocolUart.WriteToFile()
    return
def FrameProtocolUartOnClearAll():
    FrameApplication.tbsProtocolUart.ClearAll()
    return
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    try:
        UartController.Close()
        FrameApplication.WriteInitdata(DEF.NAME_INITFILE)
    except:
        pass
#--------------------------------------------------------------------
#   Field - Global
#--------------------------------------------------------------------
UartController = URT.CUart()
UartController.SetOnProtocol(OnProtocol)
UartController.SetOnOpen(UartOnOpen)
UartController.SetOnClose(UartOnClose)
UartController.SetOnLineReceived(UartOnLineReceived)
UartController.SetOnLineTransmit(UartOnLineTransmit)
#
FrameApplication = FRA.CFrameApplication(TKI.Tk(),
                                         OnFrameApplicationDelete)
FrameApplication.SetOnProtocolWriteToFile(FrameProtocolOnWriteToFile)
FrameApplication.SetOnProtocolClearAll(FrameProtocolOnClearAll)
FrameApplication.SetOnProtocolUartWriteToFile(FrameProtocolUartOnWriteToFile)
FrameApplication.SetOnProtocolUartClearAll(FrameProtocolUartOnClearAll)
#
FRM = FrameApplication.tbsSystem.frmSystemCommon
FRM.SetSystemOnReset(FrameSystemCommonOnReset)
FRM.SetSystemOnAbort(FrameSystemCommonOnAbort)
FRM.SetSystemOnRefreshInterval(FrameSystemCommonOnRefreshInterval)
#
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnSetOn(FrameSystemLedOnSetOn)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnSetOff(FrameSystemLedOnSetOff)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnInvert(FrameSystemLedOnInvert)
FrameApplication.tbsSystem.frmSystemLed.SetLedSystemOnBlink(FrameSystemLedOnBlink)
#
FrameApplication.tbsUart.FrameUartSetup.SetLinkUart(UartController)
FrameApplication.tbsUart.FrameUartProtocol.SetOnTransmitLine(FrameUartProtocolOnTransmitLine)
