//
#include "SerialUart.h"
//
extern Character BufferLine[];
//
CSerialUart::CSerialUart(int pinrxd, int pintxd)
{
    FPinRxD = pinrxd;
    FPinTxD = pintxd;
    FPUart = new HardwareSerial(FPinRxD, FPinTxD);
}

void CSerialUart::Open(int baudrate)
{
    FPUart->begin(baudrate);
}
//
void CSerialUart::Write(const char* value)
{
    sprintf(BufferLine, "%s", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(char* value)
{
    sprintf(BufferLine, "%s", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(Int8 value)
{
    sprintf(BufferLine, "%i", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(UInt8 value)
{
    sprintf(BufferLine, "%u", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(Int16 value)
{
    sprintf(BufferLine, "%i", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(UInt16 value)
{
    sprintf(BufferLine, "%u", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(Int32 value)
{
    sprintf(BufferLine, "%i", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(UInt32 value)
{
    sprintf(BufferLine, "%u", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(Float32 value)
{
    sprintf(BufferLine, "%f", value);
    FPUart->print(BufferLine);
}
void CSerialUart::Write(Double64 value)
{
    sprintf(BufferLine, "%f", value);
    FPUart->print(BufferLine);
}
