//
#include "Led.h"

CLed::CLed(int pin, bool inverted)
{
    FState = sldOff;
    FPin = pin;
    FInverted = inverted;
}
//
void CLed::Open(EStateLed state)
{
    pinMode(FPin, OUTPUT);
    Set(state);
}
//
void CLed::Set(EStateLed state)
{
    FState = state;
    if (FInverted)
    {
        if (sldOn == FState)
        {
            digitalWrite(FPin, LOW);
        }
        else
        {
            digitalWrite(FPin, HIGH);
        }
    }
    else
    {
        if (sldOn == FState)
        {
            digitalWrite(FPin, HIGH);
        }
        else
        {
            digitalWrite(FPin, LOW);
        }
    }
}
//
EStateLed CLed::Get(void)
{    
    return FState;
}
//
EStateLed CLed::Invert(void)
{
    if (sldOff == Get())
    {
        Set(sldOn);
    }
    else
    {
        Set(sldOff);
    }
    return Get();
}
//