//
#ifndef SerialUart_h
#define SerialUart_h
//
#include <Arduino.h>
#include <HardwareSerial.h>
//
#include "Define.h"
#include "Helper.h"
//
class CSerialUart
{
    protected:
    int FPinRxD, FPinTxD;
    HardwareSerial *FPUart;
    Character FRxCharacter;
    byte FRxIndex;
    Character FRxBuffer[SIZE_RXBUFFER];
    Character FTxBuffer[SIZE_TXBUFFER];
    //
    public:
    CSerialUart(int pinrxd, int pintxd); 
    //
    void Open(int baudrate);
    //
    Boolean ReadCharacter(Character &character);
    Boolean ReadLine(PCharacter pcharacter);
    //
    void WriteLine(void);
    void Write(const char* value);
    void Write(char* value);
    void Write(Int8 value);
    void Write(UInt8 value);
    void Write(Int16 value);
    void Write(UInt16 value);
    void Write(Int32 value);
    void Write(UInt32 value);
    void Write(Float32 value);
    void Write(Double64 value);
    //
    Boolean Execute(void);
};
//
#endif // Uart_h
//